/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.clutch;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.kinetics.generator.clutch.GeneratorClutchBlockEntity;
import org.patryk3211.powergrid.utility.Lang;

public class ClutchDisplaySource
extends PercentOrProgressBarDisplaySource {
    private Optional<GeneratorClutchBlockEntity> get(DisplayLinkContext ctx) {
        BlockEntity blockEntity = ctx.getSourceBlockEntity();
        if (blockEntity instanceof GeneratorClutchBlockEntity) {
            GeneratorClutchBlockEntity clutch = (GeneratorClutchBlockEntity)blockEntity;
            return Optional.of(clutch);
        }
        return Optional.empty();
    }

    @Nullable
    protected Float getProgress(DisplayLinkContext context) {
        return this.get(context).map(be -> Float.valueOf(be.load)).orElse(Float.valueOf(0.0f));
    }

    protected MutableComponent formatNumeric(DisplayLinkContext context, Float currentLevel) {
        if (this.getMode(context) != 2) {
            return super.formatNumeric(context, currentLevel);
        }
        return this.get(context).map(be -> Lang.numberConstant(Math.abs(be.rotorBehaviour.getAngularVelocity())).add(Component.m_237113_((String)" ")).add(CreateLang.translate((String)"generic.unit.rpm", (Object[])new Object[0])).component()).orElseGet(() -> super.formatNumeric(context, currentLevel));
    }

    public int getPassiveRefreshTicks() {
        return 40;
    }

    protected boolean progressBarActive(DisplayLinkContext context) {
        return this.getMode(context) == 0;
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

    protected String getTranslationKey() {
        return "generator_clutch";
    }

    private int getMode(DisplayLinkContext context) {
        return context.sourceConfig().m_128451_("Mode");
    }

    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.generator_clutch", "load_bar", "load_value", "rpm")).titled(Lang.translateDirect("display_source.display_information", new Object[0])), "Mode");
    }
}

