/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.variac;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.TransformerCoupling;
import org.patryk3211.powergrid.electricity.transformer.TransformerSoundInstance;
import org.patryk3211.powergrid.electricity.transformer.TransformerVolumeProvider;
import org.patryk3211.powergrid.kinetics.base.TunedBlockEntity;
import org.patryk3211.powergrid.utility.Lang;

public class VariacBlockEntity
extends TunedBlockEntity
implements TransformerVolumeProvider,
IHaveGoggleInformation {
    public static final float PRIMARY_TURNS = 25.0f;
    public static final float CORE_AL = 1.5f;
    public static final float COUPLING_FACTOR = 0.9999f;
    public static final float PRIMARY_INDUCTANCE = 937.5f;
    protected ElectricWire primaryStray;
    protected ElectricWire mutualInductance;
    protected TransformerCoupling coupling;
    public float lastCurrent;
    private boolean hasSoundSource;

    public VariacBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig((SmartBlockEntity)this);
    }

    @Override
    public float getVolume() {
        float volume = this.lastCurrent / 80.0f;
        return Mth.m_14036_((float)(volume * volume), (float)0.0f, (float)0.5f);
    }

    public float getRatio() {
        if (this.arm == null) {
            return 0.01f;
        }
        return this.arm.getValue() * 0.99f + 0.01f;
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(3);
        float secondaryTurns = this.getRatio() * 25.0f;
        float secondaryInductance = secondaryTurns * secondaryTurns * 1.5f;
        float mutualInductance = secondaryInductance * 0.9999f;
        float ratio = this.getRatio();
        float primaryStray = 937.5f - mutualInductance;
        float secondaryStray = secondaryInductance - ratio * ratio * mutualInductance;
        FloatingNode Tnode = builder.addInternalNode();
        this.primaryStray = builder.connect(primaryStray, builder.terminalNode(0), Tnode);
        this.mutualInductance = builder.connect(mutualInductance, Tnode, builder.terminalNode(1));
        this.coupling = builder.couple(ratio, secondaryStray * ratio * ratio, Tnode, builder.terminalNode(1), builder.terminalNode(2), builder.terminalNode(1));
    }

    @Override
    public void refreshParameters() {
        float secondaryTurns = this.getRatio() * 25.0f;
        float secondaryInductance = secondaryTurns * secondaryTurns * 1.5f;
        float ratio = this.getRatio();
        float mutualInductance = secondaryInductance / (ratio * ratio) * 0.9999f;
        float primaryStray = 937.5f - mutualInductance;
        float secondaryStray = secondaryInductance - ratio * ratio * mutualInductance;
        this.primaryStray.setResistance(primaryStray);
        this.mutualInductance.setResistance(mutualInductance);
        this.coupling.setRatio(ratio);
        this.coupling.setResistance(secondaryStray * ratio * ratio);
    }

    @Override
    public void tick() {
        float power = 0.0f;
        this.lastCurrent = 0.0f;
        if (this.primaryStray != null && this.primaryStray.isConverged()) {
            float I1 = this.primaryStray.current();
            power += (float)((double)(I1 * I1) * this.primaryStray.getResistance());
            this.lastCurrent += Math.abs(I1);
        }
        if (this.mutualInductance != null && this.mutualInductance.isConverged()) {
            float I3 = this.mutualInductance.current();
            power += (float)((double)(I3 * I3) * this.mutualInductance.getResistance());
            this.lastCurrent += Math.abs(I3);
        }
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyTickPower(power);
        }
        super.tick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (!this.hasSoundSource && this.getVolume() > 0.0f) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new TransformerSoundInstance(this));
            this.hasSoundSource = true;
        } else if (this.hasSoundSource && this.getVolume() <= 0.0f) {
            this.hasSoundSource = false;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!isPlayerSneaking) {
            return false;
        }
        Lang.builder().translate("gui.transformer.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.transformer.ratio", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        LangBuilder ratio = Lang.number(1.0f / this.getRatio()).add(Component.m_237113_((String)":1"));
        ratio.style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        return true;
    }
}

