/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.equipment.multimeter.MultimeterItem;
import org.patryk3211.powergrid.network.SimplePacket;

public class MultimeterDataC2SPacket
implements SimplePacket {
    private final Vector3f point;
    private final int wire;

    public MultimeterDataC2SPacket(Vec3 point, BaseWireEntity wire) {
        this.point = point.m_252839_();
        this.wire = wire.m_19879_();
    }

    public MultimeterDataC2SPacket(FriendlyByteBuf buf) {
        this.point = buf.m_269394_();
        this.wire = buf.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_269582_(this.point);
        buf.writeInt(this.wire);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            Player player = ctx.getPlayer();
            ItemStack stack = player.m_21205_();
            Item patt0$temp = stack.m_41720_();
            if (!(patt0$temp instanceof MultimeterItem)) {
                return;
            }
            MultimeterItem multimeter = (MultimeterItem)patt0$temp;
            Level level = player.m_9236_();
            Entity entity = level.m_6815_(this.wire);
            if (entity == null) {
                return;
            }
            if (multimeter.getMode(stack) != 1) {
                multimeter.setMode(stack, 1);
            }
            CompoundTag data = multimeter.getModeData(stack);
            data.m_128350_("X", this.point.x);
            data.m_128350_("Y", this.point.y);
            data.m_128350_("Z", this.point.z);
            data.m_128362_("UUID", entity.m_20148_());
        });
    }
}

