/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.properties;

import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;

public class EnumProperty<T extends Enum<T>>
extends ComponentProperty<T> {
    private final Class<T> clazz;
    private final T[] values;
    private final T defaultValue;

    public EnumProperty(String namespace, String name, Class<T> clazz) {
        super(namespace, name);
        this.clazz = clazz;
        this.values = (Enum[])clazz.getEnumConstants();
        this.defaultValue = this.values[0];
    }

    public EnumProperty(String namespace, String name, Class<T> clazz, T[] values) {
        super(namespace, name);
        this.clazz = clazz;
        this.values = values;
        this.defaultValue = values[0];
    }

    public EnumProperty(String namespace, String name, Class<T> clazz, T[] values, T defaultValue) {
        super(namespace, name);
        this.clazz = clazz;
        this.values = values;
        this.defaultValue = defaultValue;
    }

    @Override
    public T parse(String str) {
        for (T value : this.values) {
            if (!((Enum)value).name().equals(str)) continue;
            return value;
        }
        return null;
    }

    @Override
    public String toString(T value) {
        return ((Enum)value).name();
    }

    @Override
    public T read(@Nullable Tag element) {
        if (element == null) {
            return this.defaultValue;
        }
        if (element.m_7060_() != 3) {
            return this.defaultValue;
        }
        int value = ((IntTag)element).m_7047_();
        return this.values[value];
    }

    @Override
    public Tag write(T value) {
        return IntTag.m_128679_((int)((Enum)value).ordinal());
    }

    @Override
    public T defaultValue() {
        return this.defaultValue;
    }
}

