/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.collections;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllSoundEvents;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;

public class ModdedSoundEvents {
    public static final Map<ResourceLocation, AllSoundEvents.SoundEntry> ALL = new HashMap<ResourceLocation, AllSoundEvents.SoundEntry>();
    public static final AllSoundEvents.SoundEntry LV_SWITCH_CLICK = ModdedSoundEvents.create("lv_switch_click").subtitle("Switch clicks").playExisting(SoundEvents.f_12088_).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry MV_SWITCH_CLICK = ModdedSoundEvents.create("mv_switch_click").subtitle("Switch clicks").playExisting(SoundEvents.f_12011_).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry HV_SWITCH_CONNECT = ModdedSoundEvents.create("hv_switch_connect").subtitle("Switch connected").playExisting(() -> ((AllSoundEvents.SoundEntry)AllSoundEvents.CONTRAPTION_DISASSEMBLE).getMainEvent(), 0.5f, 0.75f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry HV_SWITCH_DISCONNECT = ModdedSoundEvents.create("hv_switch_disconnect").subtitle("Switch disconnected").playExisting(() -> ((AllSoundEvents.SoundEntry)AllSoundEvents.CONTRAPTION_ASSEMBLE).getMainEvent(), 0.5f, 0.75f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry CONTACTOR_ON = ModdedSoundEvents.create("contactor_on").subtitle("Contactor connects").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry CONTACTOR_OFF = ModdedSoundEvents.create("contactor_off").subtitle("Contactor disconnects").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry WIRE_CUT = ModdedSoundEvents.create("wire_cut").subtitle("Wire cut").playExisting(SoundEvents.f_12344_, 0.75f, 1.25f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry MAGNETIZING = ModdedSoundEvents.create("magnetizing").subtitle("Magnetizing").addVariant("magnetizing").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry ELECTROZAPPER_SHOOT = ModdedSoundEvents.create("electrozapper_shoot").subtitle("Electro-Zapper bzzzts").category(SoundSource.PLAYERS).build();
    public static final AllSoundEvents.SoundEntry UI_CLICK = ModdedSoundEvents.create("ui.click").noSubtitle().playExisting((Holder)SoundEvents.f_12490_).build();
    public static final AllSoundEvents.SoundEntry UI_COMPONENT_ROTATE = ModdedSoundEvents.create("ui.component_rotate").noSubtitle().playExisting(SoundEvents.f_12017_, 0.75f, 0.75f).build();
    public static final AllSoundEvents.SoundEntry UI_PLACE_TRACE = ModdedSoundEvents.create("ui.place_trace").noSubtitle().playExisting(SoundEvents.f_12065_, 0.75f, 1.75f).build();
    public static final AllSoundEvents.SoundEntry UI_DELETE_AREA = ModdedSoundEvents.create("ui.delete_area").noSubtitle().playExisting(SoundEvents.f_12016_, 0.5f, 1.0f).build();
    public static final AllSoundEvents.SoundEntry UI_PLACE_COMPONENT = ModdedSoundEvents.create("ui.place_component").noSubtitle().playExisting(SoundEvents.f_12013_, 0.5f, 1.0f).build();
    public static final AllSoundEvents.SoundEntry UI_FAIL = ModdedSoundEvents.create("ui.action.fail").noSubtitle().playExisting((SoundEvent)SoundEvents.f_12209_.m_203334_(), 1.0f, 0.5f).build();
    public static final AllSoundEvents.SoundEntry UI_SELECT_COMPONENT = ModdedSoundEvents.create("ui.select_component").noSubtitle().playExisting((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f, 1.0f).build();
    public static final AllSoundEvents.SoundEntry RELAY_CLICK = ModdedSoundEvents.create("relay_click").subtitle("Relay clicks").playExisting(SoundEvents.f_12088_).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry COMPONENT_EXPLODE = ModdedSoundEvents.create("component_explode").subtitle("Component pops").playExisting(SoundEvents.f_11928_, 0.25f, 2.0f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry FUSE_POPS = ModdedSoundEvents.create("fuse_pops").subtitle("Fuse pops").playExisting(SoundEvents.f_11928_, 0.5f, 1.6f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry MICROSWITCH_ON = ModdedSoundEvents.create("uswitch_on").subtitle("Switch clicks").playExisting(SoundEvents.f_12632_, 1.0f, 2.0f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry MICROSWITCH_OFF = ModdedSoundEvents.create("uswitch_off").subtitle("Switch clicks").playExisting(SoundEvents.f_12631_, 1.0f, 2.0f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry MICROBUTTON_ON = ModdedSoundEvents.create("ubutton_on").subtitle("Button clicks").playExisting(SoundEvents.f_12632_, 0.75f, 2.0f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry MICROBUTTON_OFF = ModdedSoundEvents.create("ubutton_off").subtitle("Button clicks").playExisting(SoundEvents.f_12631_, 0.75f, 2.0f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry TRANSFORMER_HUM = ModdedSoundEvents.create("transformer").subtitle("Transformer hum").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry GENERATOR = ModdedSoundEvents.create("generator").subtitle("Generator spinning").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry ALARM_BELL = ModdedSoundEvents.create("alarm_bell").subtitle("Alarm bell rings").category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry ALARM_BELL_END = ModdedSoundEvents.create("alarm_bell_end").noSubtitle().category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry FUSE_INSTALL = ModdedSoundEvents.create("fuse_install").subtitle("Fuse installed").playExisting(SoundEvents.f_12013_, 0.8f, 0.7f).category(SoundSource.BLOCKS).build();
    public static final AllSoundEvents.SoundEntry WIRE_BURNED = ModdedSoundEvents.create("wire_burned").subtitle("Wire burned").playExisting(SoundEvents.f_11937_, 0.2f, 2.0f).category(SoundSource.NEUTRAL).build();

    private static SoundEntryBuilder create(String name) {
        return ModdedSoundEvents.create(PowerGrid.asResource(name));
    }

    public static SoundEntryBuilder create(ResourceLocation id) {
        return new SoundEntryBuilder(id);
    }

    public static void prepare() {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            entry.prepare();
        }
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (AllSoundEvents.SoundEntry entry : ALL.values()) {
            if (!entry.hasSubtitle()) continue;
            consumer.accept(entry.getSubtitleKey(), entry.getSubtitle());
        }
    }

    public static DataProvider provider(PackOutput output) {
        return new SoundEntryProvider(output);
    }

    public static class SoundEntryBuilder
    extends AllSoundEvents.SoundEntryBuilder {
        public SoundEntryBuilder(ResourceLocation id) {
            super(id);
        }

        public AllSoundEvents.SoundEntryBuilder addVariant(String name) {
            return this.addVariant(PowerGrid.asResource(name));
        }

        public AllSoundEvents.SoundEntry build() {
            AllSoundEvents.SoundEntry entry = super.build();
            ALL.put(entry.getId(), entry);
            return entry;
        }
    }

    private static class SoundEntryProvider
    implements DataProvider {
        private final PackOutput output;

        public SoundEntryProvider(PackOutput output) {
            this.output = output;
        }

        @NotNull
        public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
            return this.generate(this.output.m_245114_(), cache);
        }

        @NotNull
        public String m_6055_() {
            return "Power Grid's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, CachedOutput cache) {
            path = path.resolve("assets/powergrid");
            JsonObject json = new JsonObject();
            ALL.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((AllSoundEvents.SoundEntry)entry.getValue()).write(json));
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }
}

