/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.battery.AbstractBatteryBlock;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;
import org.patryk3211.powergrid.electricity.battery.CustomConnectivityHandler;
import org.patryk3211.powergrid.electricity.battery.MultiBlockBatteryEntity;
import org.patryk3211.powergrid.electricity.deviceconnector.IAcceptConnector;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Power;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.utility.Lang;

public class BatteryBlock
extends AbstractBatteryBlock<MultiBlockBatteryEntity>
implements IAcceptConnector,
IHaveElectricProperties {
    protected BatterySpec spec;

    public BatteryBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public static <T extends BatteryBlock, P> NonNullUnaryOperator<BlockBuilder<T, P>> setSpec(BatterySpec spec) {
        return b -> (BlockBuilder)b.onRegister(block -> {
            block.spec = spec;
        });
    }

    @Override
    public BatterySpec getSpec() {
        return this.spec;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.m_60734_() == state.m_60734_()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, MultiBlockBatteryEntity::queueConnectivityUpdate);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof MultiBlockBatteryEntity)) {
                return;
            }
            MultiBlockBatteryEntity battery = (MultiBlockBatteryEntity)be;
            List<TransmissionLinePart> wires = GlobalElectricNetworks.getWorldNetworks(world).findConnectedWires(battery.getElectricBehaviour());
            super.m_6810_(state, world, pos, newState, moved);
            CustomConnectivityHandler.splitMulti(battery);
            wires.forEach(TransmissionLinePart::refreshEndpointNodes);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List stacks = super.m_49635_(state, builder);
        BlockEntity be = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (be instanceof MultiBlockBatteryEntity) {
            MultiBlockBatteryEntity battery = (MultiBlockBatteryEntity)be;
            for (ItemStack stack : stacks) {
                if (!stack.m_150930_(this.m_5456_())) continue;
                CompoundTag tag = stack.m_41784_();
                tag.m_128347_("Energy", Math.floor(battery.getIndividualEnergy()));
                break;
            }
        }
        return stacks;
    }

    public Class<MultiBlockBatteryEntity> getBlockEntityClass() {
        return MultiBlockBatteryEntity.class;
    }

    public BlockEntityType<? extends MultiBlockBatteryEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.MULTIBLOCK_BATTERY.get();
    }

    @Override
    public boolean isPolarized() {
        return true;
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Voltage.max(this.spec.calculateVoltage(1.0f), player, tooltip);
        Power.max(stack, player, tooltip);
        float charge = !stack.m_41782_() || !stack.m_41783_().m_128441_("Energy") ? this.getSpec().getInitialCharge() / this.getSpec().getMaxCharge() : (float)(stack.m_41783_().m_128459_("Energy") / (double)this.getSpec().getMaxCharge());
        Lang.translate("tooltip.charge.current", new Object[0]).style(ChatFormatting.GRAY).addTo(tooltip);
        Lang.builder().add(Component.m_237113_((String)" ")).add(Lang.numberConstant(charge * 100.0f)).add(Component.m_237113_((String)"%")).style(ChatFormatting.AQUA).addTo(tooltip);
    }
}

