/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.bell;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.bell.AlarmBellSoundInstance;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class AlarmBellBlockEntity
extends ElectricBlockEntity {
    private ElectricWire wire;
    private boolean hasSoundInstance = false;

    public AlarmBellBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        if (this.getVolume() > 0.0f && !this.hasSoundInstance) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new AlarmBellSoundInstance(this));
            this.hasSoundInstance = true;
        } else if (this.getVolume() == 0.0f && this.hasSoundInstance) {
            this.hasSoundInstance = false;
        }
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.tickAudio();
        }
    }

    public float getVolume() {
        float I = Math.abs(this.wire.current());
        if (I < 0.25f) {
            return 0.0f;
        }
        return I * 2.0f;
    }

    public float getPitch() {
        float I = Math.abs(this.wire.current());
        if (I < 0.5f) {
            return 0.75f;
        }
        return Math.min(0.5f + I * 0.5f, 1.25f);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }
}

