/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.creative;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.creative.CreativeSourceValueBehaviour;
import org.patryk3211.powergrid.electricity.sim.node.CurrentSourceNode;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class CreativeSourceBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    private ScrollValueBehaviour value;
    private CurrentSourceNode currentSourceNode;
    private VoltageSourceCoupling voltageSourceNode;
    private boolean overwrite = false;
    private boolean voltageSource;

    public CreativeSourceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        float multiplier;
        super.addBehaviours(behaviours);
        MutableComponent label = null;
        if (this.m_58900_().m_60713_((Block)ModdedBlocks.CREATIVE_VOLTAGE_SOURCE.get())) {
            label = Lang.translateDirect("devices.creative.voltage", new Object[0]);
            multiplier = 1.0f;
        } else if (this.m_58900_().m_60713_((Block)ModdedBlocks.CREATIVE_CURRENT_SOURCE.get())) {
            label = Lang.translateDirect("devices.creative.current", new Object[0]);
            multiplier = 0.1f;
        } else {
            multiplier = 0.0f;
        }
        this.value = new CreativeSourceValueBehaviour((Component)label, this, multiplier, (ValueBoxTransform)new CreativeSourceBoxTransform());
        this.value.withCallback(i -> {
            if (!this.overwrite) {
                this.setValue((float)i.intValue() * multiplier);
            }
        });
        behaviours.add((BlockEntityBehaviour)this.value);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        FloatingNode positive = builder.terminalNode(0);
        FloatingNode negative = builder.terminalNode(1);
        if (this.m_58900_().m_60713_((Block)ModdedBlocks.CREATIVE_VOLTAGE_SOURCE.get())) {
            this.voltageSource = true;
            this.voltageSourceNode = builder.addInternalNode(VoltageSourceCoupling.class, positive, negative, Float.valueOf(1.0E-4f));
        } else if (this.m_58900_().m_60713_((Block)ModdedBlocks.CREATIVE_CURRENT_SOURCE.get())) {
            this.voltageSource = false;
            this.currentSourceNode = builder.addInternalNode(CurrentSourceNode.class, new Object[0]);
            builder.couple(1.0f, 1.0E-4f, (IElectricNode)this.currentSourceNode, (IElectricNode)positive, (IElectricNode)negative);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("Overwrite")) {
            this.overwrite = tag.m_128471_("Overwrite");
        }
        this.setValue(tag.m_128457_("NodeValue"));
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.overwrite) {
            tag.m_128379_("Overwrite", true);
        }
        tag.m_128350_("NodeValue", this.getValue());
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        if (this.overwrite) {
            tag.m_128379_("Overwrite", true);
        }
        tag.m_128350_("NodeValue", this.getValue());
    }

    public void setValue(float value) {
        if (this.voltageSource) {
            this.voltageSourceNode.setVoltage(value);
        } else {
            this.currentSourceNode.setCurrent(value);
        }
    }

    public float getValue() {
        if (this.voltageSource) {
            return this.voltageSourceNode.getVoltage();
        }
        return this.currentSourceNode.getCurrent();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate("gui.creative_source.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.creative_source.voltage", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float voltage = this.voltageSource ? this.voltageSourceNode.getVoltage() : this.currentSourceNode.getVoltage();
        String voltageText = String.format("%.2f", Float.valueOf(voltage));
        Lang.builder().text(voltageText).add(Component.m_130674_((String)" ")).add(Unit.VOLTAGE.get()).style(ChatFormatting.BLUE).forGoggles(tooltip, 1);
        Lang.builder().translate("gui.creative_source.current", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float current = this.voltageSource ? -this.voltageSourceNode.getCurrent() : this.currentSourceNode.getCurrent();
        String currentText = String.format("%.2f", Float.valueOf(current));
        Lang.builder().text(currentText).add(Component.m_130674_((String)" ")).add(Unit.CURRENT.get()).style(ChatFormatting.GREEN).forGoggles(tooltip, 1);
        return true;
    }

    public static class CreativeSourceBoxTransform
    extends CenteredSideValueBoxTransform {
        public CreativeSourceBoxTransform() {
            super((state, dir) -> dir.m_122434_() != Direction.Axis.Y);
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)14.5);
        }
    }
}

