/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electromagnet;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.electromagnet.MagnetizingBehaviour;
import org.patryk3211.powergrid.electricity.electromagnet.recipe.MagnetizingRecipe;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class ElectromagnetBlockEntity
extends ElectricBlockEntity
implements MagnetizingBehaviour.MagnetizingBehaviourSpecifics {
    private ElectricWire wire;
    private MagnetizingBehaviour magnetizingBehaviour;
    private static final Container magnetizingInv = new SimpleContainer(1);

    public ElectromagnetBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.magnetizingBehaviour = new MagnetizingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.magnetizingBehaviour);
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.magnetizingBehaviour.running) {
            this.wire.setResistance(this.resistance() * 0.5f);
        } else {
            this.wire.setResistance(this.resistance());
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connect(this.resistance(), builder.terminalNode(0), builder.terminalNode(1));
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<MagnetizingRecipe> recipe = this.getRecipe(input.stack);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        List outputs = RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)input.stack.m_255036_(1), (Recipe)((Recipe)recipe.get()), (boolean)true);
        outputList.addAll(outputs);
        return true;
    }

    @Override
    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack item = itemEntity.m_32055_();
        Optional<MagnetizingRecipe> recipe = this.getRecipe(item);
        if (recipe.isEmpty()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)item.m_255036_(1), (Recipe)((Recipe)recipe.get()), (boolean)true)) {
            ItemEntity created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
            created.m_32060_();
            created.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
            this.f_58857_.m_7967_((Entity)created);
        }
        item.m_41774_(1);
        return true;
    }

    @Override
    public void onMagnetizationComplete() {
    }

    @Override
    public float getFieldStrength() {
        float field;
        float I = this.wire.current();
        if (this.isVirtual()) {
            I = (float)((double)this.wire.potentialDifference() * this.wire.conductance());
        }
        if ((field = Math.abs(I * 0.1f)) < 0.25f) {
            return 0.0f;
        }
        return field;
    }

    public Optional<MagnetizingRecipe> getRecipe(ItemStack item) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, MagnetizingRecipe.TYPE_INFO.getType(), MagnetizingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        magnetizingInv.m_6836_(0, item);
        return this.f_58857_.m_7465_().m_44015_(MagnetizingRecipe.TYPE_INFO.getType(), magnetizingInv, this.f_58857_);
    }

    public MagnetizingBehaviour getMagnetizingBehaviour() {
        return this.magnetizingBehaviour;
    }
}

