/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.febridge;

import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public interface IFEBridgeHandler {
    public static float voltToFE() {
        return ModdedConfigs.server().electricity.forgeEnergyPerVolt.getF();
    }

    public static float wattToFE() {
        return ModdedConfigs.server().electricity.forgeEnergyPerWatt.getF();
    }

    public long getAmount();

    public void setAmount(long var1);

    default public void charge(SwitchedWire wire) {
        float wattsToFE = IFEBridgeHandler.wattToFE();
        if (wire.getState()) {
            float I = wire.current();
            this.setAmount(this.getAmount() + Math.round((double)(I * I) * wire.getResistance() * (double)wattsToFE));
            this.setChanged();
        }
    }

    public long moveEnergy();

    public void setChanged();

    default public void manageWire(SwitchedWire wire) {
        float V = Math.abs(wire.potentialDifference());
        long maxCharge = (long)(V * IFEBridgeHandler.voltToFE());
        long missingCharge = maxCharge - this.getAmount();
        if (missingCharge <= 0L) {
            wire.setState(false);
            return;
        }
        float targetWatts = (float)missingCharge / IFEBridgeHandler.wattToFE();
        float resistance = V * V / targetWatts;
        if (resistance > 0.0f) {
            wire.setResistance(resistance);
            wire.setState(true);
        } else {
            wire.setState(false);
        }
    }
}

