/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.transformer;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.FloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.TransformerCoupling;
import org.patryk3211.powergrid.electricity.transformer.TransformerCoilParameters;
import org.patryk3211.powergrid.electricity.transformer.TransformerSoundInstance;
import org.patryk3211.powergrid.electricity.transformer.TransformerVolumeProvider;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public abstract class TransformerBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation,
TransformerVolumeProvider {
    protected TransformerCoilParameters primaryCoil;
    protected TransformerCoilParameters secondaryCoil;
    protected ElectricWire primaryStray;
    protected ElectricWire mutualInductance;
    protected TransformerCoupling coupling;
    public float lastCurrent;
    private boolean hasSoundSource;

    public TransformerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    public abstract double coreAl();

    public abstract double couplingFactor();

    public void tick() {
        float power = 0.0f;
        this.lastCurrent = 0.0f;
        if (this.primaryStray != null && this.primaryStray.isConverged()) {
            float I1 = this.primaryStray.current();
            double P12 = (double)(I1 * I1) * this.primaryStray.getResistance();
            power = (float)((double)power + P12);
            this.lastCurrent += Math.abs(I1);
        }
        if (this.mutualInductance != null && this.mutualInductance.isConverged()) {
            float I3 = this.mutualInductance.current();
            double P32 = (double)(I3 * I3) * this.mutualInductance.getResistance();
            power = (float)((double)power + P32);
            this.lastCurrent += Math.abs(I3);
        }
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyTickPower(power);
        }
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.tickAudio();
        }
    }

    @Override
    public float getVolume() {
        float volume = this.lastCurrent / 80.0f;
        return Mth.m_14036_((float)(volume * volume), (float)0.0f, (float)0.333f);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickAudio() {
        if (!this.hasSoundSource && this.getVolume() > 0.0f) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new TransformerSoundInstance(this));
            this.hasSoundSource = true;
        } else if (this.hasSoundSource && this.getVolume() <= 0.0f) {
            this.hasSoundSource = false;
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        boolean rebuild = false;
        if (tag.m_128441_("Primary")) {
            CompoundTag primary = tag.m_128469_("Primary");
            rebuild |= this.primaryCoil.readNbt(primary);
        } else if (this.primaryCoil != null) {
            rebuild |= this.primaryCoil.clear();
        }
        if (tag.m_128441_("Secondary")) {
            CompoundTag secondary = tag.m_128469_("Secondary");
            rebuild |= this.secondaryCoil.readNbt(secondary);
        } else if (this.primaryCoil != null) {
            rebuild |= this.secondaryCoil.clear();
        }
        if (rebuild) {
            this.electricBehaviour.rebuildCircuit();
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.primaryCoil != null && this.primaryCoil.isDefined()) {
            CompoundTag primary = new CompoundTag();
            this.primaryCoil.writeNbt(primary);
            tag.m_128365_("Primary", (Tag)primary);
        }
        if (this.secondaryCoil != null && this.secondaryCoil.isDefined()) {
            CompoundTag secondary = new CompoundTag();
            this.secondaryCoil.writeNbt(secondary);
            tag.m_128365_("Secondary", (Tag)secondary);
        }
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        if (this.primaryCoil != null && this.primaryCoil.isDefined()) {
            CompoundTag primary = new CompoundTag();
            this.primaryCoil.writeNbt(primary);
            tag.m_128365_("Primary", (Tag)primary);
        }
        if (this.secondaryCoil != null && this.secondaryCoil.isDefined()) {
            CompoundTag secondary = new CompoundTag();
            this.secondaryCoil.writeNbt(secondary);
            tag.m_128365_("Secondary", (Tag)secondary);
        }
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        int count = 0;
        if (this.primaryCoil != null) {
            count += this.primaryCoil.getTurns();
        }
        if (this.secondaryCoil != null) {
            count += this.secondaryCoil.getTurns();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        while (count > 0) {
            stacks.add(ModdedItems.WIRE.asStack(Math.min(count, 64)));
            count -= 64;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    public boolean isTerminalUsed(int index) {
        if (this.primaryCoil.isDefined() && (this.primaryCoil.getTerminal1() == index || this.primaryCoil.getTerminal2() == index)) {
            return true;
        }
        return this.secondaryCoil.isDefined() && (this.secondaryCoil.getTerminal1() == index || this.secondaryCoil.getTerminal2() == index);
    }

    public void makePrimary(int terminal1, int terminal2, int turns, Item item) {
        this.primaryCoil.set(terminal1, terminal2, turns, item);
        this.electricBehaviour.rebuildCircuit();
        this.notifyUpdate();
    }

    public boolean hasPrimary() {
        return this.primaryCoil.isDefined();
    }

    public TransformerCoilParameters getPrimary() {
        return this.primaryCoil;
    }

    public void makeSecondary(int terminal1, int terminal2, int turns, Item item) {
        this.secondaryCoil.set(terminal1, terminal2, turns, item);
        this.electricBehaviour.rebuildCircuit();
        this.notifyUpdate();
    }

    public boolean hasSecondary() {
        return this.secondaryCoil.isDefined();
    }

    public TransformerCoilParameters getSecondary() {
        return this.secondaryCoil;
    }

    public void removeSecondary() {
        this.secondaryCoil.clear();
        this.electricBehaviour.rebuildCircuit();
        this.notifyUpdate();
    }

    public void removePrimary() {
        this.primaryCoil.clear();
        this.electricBehaviour.rebuildCircuit();
        this.notifyUpdate();
    }

    public void updateCoilBlockState() {
    }

    public static float mutualMultiplier() {
        return ModdedConfigs.server().electricity.transformerMutualInductanceMultiplier.getF();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        if (this.primaryCoil == null) {
            this.primaryCoil = new TransformerCoilParameters();
            this.secondaryCoil = new TransformerCoilParameters();
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.updateCoilBlockState();
        }
        double coreAl = this.coreAl();
        double couplingFactor = this.couplingFactor();
        int primaryTurns = this.primaryCoil.getTurns();
        int secondaryTurns = this.secondaryCoil.getTurns();
        builder.setTerminalCount(4);
        double primaryInductance = (double)(primaryTurns * primaryTurns) * coreAl;
        double secondaryInductance = (double)(secondaryTurns * secondaryTurns) * coreAl;
        if (this.primaryCoil.isDefined() && this.secondaryCoil.isDefined()) {
            TransformerCoilParameters secondaryCoil;
            boolean flipped = primaryTurns > secondaryTurns;
            TransformerCoilParameters primaryCoil = flipped ? this.secondaryCoil : this.primaryCoil;
            TransformerCoilParameters transformerCoilParameters = secondaryCoil = flipped ? this.primaryCoil : this.secondaryCoil;
            if (flipped) {
                int b = primaryTurns;
                primaryTurns = secondaryTurns;
                secondaryTurns = b;
                double b2 = primaryInductance;
                primaryInductance = secondaryInductance;
                secondaryInductance = b2;
            }
            float ratio = (float)secondaryTurns / (float)primaryTurns;
            double mutualInductance = couplingFactor * primaryInductance;
            float primaryStray = (float)(primaryInductance - mutualInductance);
            float secondaryStray = (float)(secondaryInductance - (double)(ratio * ratio) * mutualInductance);
            FloatingNode Tnode = builder.addInternalNode();
            FloatingNode P12 = builder.terminalNode(primaryCoil.getTerminal1());
            FloatingNode P2 = builder.terminalNode(primaryCoil.getTerminal2());
            this.primaryStray = builder.connect(primaryStray, P12, Tnode);
            this.mutualInductance = builder.connect((float)mutualInductance * TransformerBlockEntity.mutualMultiplier(), Tnode, P2);
            this.coupling = builder.couple(ratio, secondaryStray * ratio * ratio, Tnode, P2, builder.terminalNode(secondaryCoil.getTerminal1()), builder.terminalNode(secondaryCoil.getTerminal2()));
        } else if (this.primaryCoil.isDefined()) {
            this.primaryStray = builder.connect((float)primaryInductance * TransformerBlockEntity.mutualMultiplier(), builder.terminalNode(this.primaryCoil.getTerminal1()), builder.terminalNode(this.primaryCoil.getTerminal2()));
            this.mutualInductance = null;
            this.coupling = null;
        } else if (this.secondaryCoil.isDefined()) {
            this.primaryStray = builder.connect((float)secondaryInductance * TransformerBlockEntity.mutualMultiplier(), builder.terminalNode(this.secondaryCoil.getTerminal1()), builder.terminalNode(this.secondaryCoil.getTerminal2()));
            this.mutualInductance = null;
            this.coupling = null;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!isPlayerSneaking) {
            return false;
        }
        Lang.builder().translate("gui.transformer.info_header", new Object[0]).forGoggles(tooltip);
        Lang.builder().translate("gui.transformer.ratio", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        int primaryTurns = this.primaryCoil.getTurns();
        int secondaryTurns = this.secondaryCoil.getTurns();
        int largestCommonDenominator = 1;
        if (primaryTurns > 0 && secondaryTurns > 0) {
            for (int i = 2; i <= Math.max(primaryTurns, secondaryTurns); ++i) {
                if (primaryTurns % i != 0 || secondaryTurns % i != 0) continue;
                largestCommonDenominator = i;
            }
        }
        LangBuilder n1 = Lang.number(primaryTurns / largestCommonDenominator);
        LangBuilder n2 = Lang.number(secondaryTurns / largestCommonDenominator);
        LangBuilder ratio = n1.add(Component.m_130674_((String)":")).add(n2);
        ratio.style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        if (this.primaryStray != null && this.mutualInductance != null) {
            float primary = (float)this.primaryStray.getResistance();
            float secondary = this.coupling.getResistance();
            if (primaryTurns > secondaryTurns) {
                float r = primary;
                primary = secondary;
                secondary = r;
            }
            Lang.builder().translate("gui.transformer.primary_stray", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Unit.RESISTANCE.formatWithPrefixes(primary).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            Lang.builder().translate("gui.transformer.secondary_stray", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Unit.RESISTANCE.formatWithPrefixes(secondary).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
            Lang.builder().translate("gui.transformer.parallel_resistance", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Unit.RESISTANCE.formatWithPrefixes(this.mutualInductance.getResistance()).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        } else if (this.primaryStray != null) {
            Lang.builder().translate("gui.transformer.parallel_resistance", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Unit.RESISTANCE.formatWithPrefixes(this.primaryStray.getResistance()).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        return true;
    }
}

