/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.JunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;

public class DeferredJunctionWireEndpoint
implements IWireEndpoint {
    private BlockPos entityPos;
    private UUID entityId;
    private int segmentIndex;
    private int segmentPoint;

    public DeferredJunctionWireEndpoint() {
    }

    public DeferredJunctionWireEndpoint(BlockWireEntity entity, int segmentIndex, int segmentPoint) {
        this.entityPos = entity.m_20183_();
        this.entityId = entity.m_20148_();
        this.segmentIndex = segmentIndex;
        this.segmentPoint = segmentPoint;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.DEFERRED_JUNCTION;
    }

    @Override
    public void read(CompoundTag nbt) {
        int[] posArray = nbt.m_128465_("Pos");
        this.entityPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.entityId = nbt.m_128342_("Id");
        this.segmentIndex = nbt.m_128451_("Index");
        this.segmentPoint = nbt.m_128451_("Point");
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128385_("Pos", new int[]{this.entityPos.m_123341_(), this.entityPos.m_123342_(), this.entityPos.m_123343_()});
        nbt.m_128362_("Id", this.entityId);
        nbt.m_128405_("Index", this.segmentIndex);
        nbt.m_128405_("Point", this.segmentPoint);
    }

    @Nullable
    public BlockWireEntity getEntity(Level world) {
        List entities = world.m_6443_(BlockWireEntity.class, new AABB(this.entityPos), e -> this.entityId.equals(e.m_20148_()));
        if (entities.isEmpty()) {
            return null;
        }
        return (BlockWireEntity)entities.get(0);
    }

    @Override
    @NotNull
    public Vec3 getExactPosition(Level world) {
        BlockWireEntity wire = this.getEntity(world);
        if (wire == null) {
            return this.entityPos.m_252807_();
        }
        if (this.segmentIndex >= wire.segments.size()) {
            this.segmentIndex = wire.segments.size() - 1;
        }
        BlockWireEntity.Point segment = wire.segments.get(this.segmentIndex);
        return segment.start.m_231075_(segment.direction, (double)((float)this.segmentPoint / 16.0f));
    }

    @Nullable
    public JunctionWireEndpoint resolve(Level world) {
        BlockWireEntity entity = this.getEntity(world);
        if (entity == null) {
            return null;
        }
        return entity.split(this.segmentIndex, this.segmentPoint);
    }

    @Override
    public <T extends BaseWireEntity> boolean canAcceptType(Class<T> clazz) {
        return BlockWireEntity.class.isAssignableFrom(clazz);
    }
}

