/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.multimeter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.electricity.wire.HangingWireRenderer;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.equipment.multimeter.MultimeterItem;

@OnlyIn(value=Dist.CLIENT)
public class MultimeterItemRenderer
extends CustomRenderedItemModelRenderer {
    private static final ResourceLocation TEXTURE = PowerGrid.texture("special/copper_wire");
    private static float mainPrevDial;
    private static float mainDial;
    private static float offPrevDial;
    private static float offDial;

    private static float getDialState(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float pt = AnimationTickHolder.getPartialTicks();
        if (player.m_21205_() == stack) {
            return Mth.m_14179_((float)pt, (float)mainPrevDial, (float)mainDial);
        }
        if (player.m_21206_() == stack) {
            return Mth.m_14179_((float)pt, (float)offPrevDial, (float)offDial);
        }
        return 0.0f;
    }

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ms.m_85836_();
        renderer.render(model.getOriginalModel(), light);
        if (transformType.m_269069_()) {
            double angle = -0.7853981633974483 + 1.5707963267948966 * (double)MultimeterItemRenderer.getDialState(stack);
            ms.m_272245_(new Quaternionf().rotateZ((float)angle), 0.0f, -0.140625f, 0.0f);
        }
        renderer.render(ModdedPartialModels.MULTIMETER_NEEDLE.get(), light);
        ms.m_85849_();
    }

    public static void clientTick(Level level, Player player) {
        ItemStack stack1 = player.m_21205_();
        Item item = stack1.m_41720_();
        if (item instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)item;
            mainPrevDial = mainDial;
            mainDial = multimeter.getDial(level, stack1);
        } else {
            mainDial = 0.0f;
            mainPrevDial = 0.0f;
        }
        ItemStack stack2 = player.m_21206_();
        Item item2 = stack2.m_41720_();
        if (item2 instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)item2;
            offPrevDial = offDial;
            offDial = multimeter.getDial(level, stack2);
        } else {
            offDial = 0.0f;
            offPrevDial = 0.0f;
        }
    }

    public static void renderProbe(Vec3 point, SuperRenderTypeBuffer buffer, PoseStack matrixStack, ClientLevel world, LocalPlayer player, int color) {
        HangingWireRenderer.renderFromPositions(matrixStack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)TEXTURE)), player.m_7398_(AnimationTickHolder.getPartialTicks()), point, (double)1.01f, (double)1.01f, 0.0625, (BlockAndTintGetter)world, color);
    }

    public static void render(SuperRenderTypeBuffer buffer, PoseStack matrixStack, ClientLevel world, LocalPlayer player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof MultimeterItem)) {
            return;
        }
        MultimeterItem multimeter = (MultimeterItem)item;
        CompoundTag data = multimeter.getModeData(stack);
        switch (multimeter.getMode(stack)) {
            case 0: {
                IWireEndpoint neg;
                IWireEndpoint pos = WireEndpointType.deserialize(data.m_128469_("Pos"));
                if (pos != null && pos.isValid((Level)world)) {
                    MultimeterItemRenderer.renderProbe(pos.getExactPosition((Level)world), buffer, matrixStack, world, player, -49088);
                }
                if ((neg = WireEndpointType.deserialize(data.m_128469_("Neg"))) == null || !neg.isValid((Level)world)) break;
                MultimeterItemRenderer.renderProbe(neg.getExactPosition((Level)world), buffer, matrixStack, world, player, -14671840);
                break;
            }
            case 1: {
                if (!data.m_128441_("X")) break;
                Vec3 pos = new Vec3((double)data.m_128457_("X"), (double)data.m_128457_("Y"), (double)data.m_128457_("Z"));
                MultimeterItemRenderer.renderProbe(pos, buffer, matrixStack, world, player, -14671840);
            }
        }
    }

    public static void render(SuperRenderTypeBuffer buffer, PoseStack matrixStack, ClientLevel world, LocalPlayer player) {
        MultimeterItemRenderer.render(buffer, matrixStack, world, player, player.m_21205_());
        MultimeterItemRenderer.render(buffer, matrixStack, world, player, player.m_21206_());
    }

    public static Component multimeterOverlayText(Player player) {
        ItemStack stack2;
        Item item;
        Component right = null;
        Component left = null;
        ItemStack stack1 = player.m_21205_();
        Item item2 = stack1.m_41720_();
        if (item2 instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)item2;
            right = multimeter.getText(player.m_9236_(), player, stack1);
        }
        if ((item = (stack2 = player.m_21206_()).m_41720_()) instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)item;
            left = multimeter.getText(player.m_9236_(), player, stack2);
        }
        if (right != null && left != null) {
            return Component.m_237119_().m_7220_(left).m_130946_(" - ").m_7220_(right);
        }
        if (right != null) {
            return right;
        }
        return left;
    }
}

