/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.thermometer;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.equipment.thermometer.ThermometerBlock;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class ThermometerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public float maxState;
    public float maxTemperature;
    public float dialTarget;
    public float prevDialState;
    public float dialState;
    public int redstoneOutput;

    public ThermometerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private float temperature() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)ThermometerBlock.FACING);
        ThermalBehaviour thermal = (ThermalBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)this.f_58858_.m_121945_(facing), ThermalBehaviour.TYPE);
        if (thermal != null) {
            return thermal.getTemperature();
        }
        return 22.0f;
    }

    public void tick() {
        super.tick();
        float temperature = this.temperature();
        if (temperature > this.maxTemperature) {
            this.maxTemperature = temperature;
        }
        this.dialTarget = Mth.m_14036_((float)((temperature - 22.0f) / 153.0f), (float)0.0f, (float)1.125f);
        if (!Float.isNaN(this.dialTarget)) {
            int newOutput;
            this.prevDialState = this.dialState;
            this.dialState += (this.dialTarget - this.dialState) * 0.125f;
            if (this.dialState > 1.0f && this.f_58857_.f_46441_.m_188501_() < 0.5f) {
                this.dialState -= (this.dialState - 1.0f) * this.f_58857_.f_46441_.m_188501_();
            }
            if (this.maxState < this.dialState) {
                this.maxState = this.dialState;
                this.m_6596_();
            }
            if ((newOutput = Mth.m_14143_((float)Mth.m_14036_((float)(this.dialTarget * 15.0f), (float)0.0f, (float)15.0f))) != this.redstoneOutput) {
                this.redstoneOutput = newOutput;
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void resetMax() {
        this.maxState = this.dialState;
        this.maxTemperature = this.temperature();
        this.m_6596_();
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128350_("Max", this.maxTemperature);
        tag.m_128350_("MaxState", this.maxState);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.maxTemperature = tag.m_128457_("Max");
        this.maxState = tag.m_128457_("MaxState");
    }

    private ChatFormatting color(float temperature) {
        ChatFormatting color = ChatFormatting.GREEN;
        if (temperature > 150.0f) {
            color = ChatFormatting.RED;
        } else if (temperature > 125.0f) {
            color = ChatFormatting.YELLOW;
        }
        return color;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"gui.gauge.info_header", (Object[])new Object[0]).forGoggles(tooltip);
        Lang.translate("gui.thermometer.title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float temperature = this.temperature();
        LangBuilder temperatureText = Lang.numberConstant(temperature);
        if (temperature > 175.0f) {
            temperatureText = Lang.text(">175.0");
        }
        temperatureText.add(Component.m_237113_((String)" ")).add(Unit.TEMPERATURE.get()).style(this.color(temperature)).forGoggles(tooltip);
        Lang.translate("gui.thermometer.max_title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        LangBuilder maxTemperatureText = Lang.numberConstant(this.maxTemperature);
        if (this.maxTemperature > 175.0f) {
            maxTemperatureText = Lang.text(">175.0");
        }
        maxTemperatureText.add(Component.m_237113_((String)" ")).add(Unit.TEMPERATURE.get()).style(this.color(this.maxTemperature)).forGoggles(tooltip);
        Lang.translate("gui.thermometer.click", new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
        return true;
    }
}

