/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.base;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;

public abstract class ElectricKineticBlockEntity
extends KineticBlockEntity
implements IElectricEntity {
    protected ElectricBehaviour electricBehaviour;
    @Nullable
    protected ThermalBehaviour thermalBehaviour;

    public ElectricKineticBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.electricBehaviour = new ElectricBehaviour(this);
        behaviours.add(this.electricBehaviour);
        this.thermalBehaviour = this.specifyThermalBehaviour();
        if (this.thermalBehaviour != null) {
            behaviours.add(this.thermalBehaviour);
        }
    }

    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return null;
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }
}

