/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.inductionrotor;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.CommutatorBlockEntity;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.IBrushPlacement;
import org.patryk3211.powergrid.kinetics.generator.rotor.AbstractRotorBlock;
import org.patryk3211.powergrid.utility.Directions;

public class CommutatorBlock
extends AbstractRotorBlock
implements IBE<CommutatorBlockEntity>,
IElectric,
IBrushPlacement {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    private final BlockStateTerminalCollection terminals;
    private final ImmutableMap<BlockState, VoxelShape> outlines;
    private static final TerminalBoundingBox[] TERMINALS_HORIZONTAL = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.POSITIVE, 0.0, 14.0, 6.0, 3.0, 16.0, 9.0).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.NEGATIVE, 13.0, 14.0, 7.0, 16.0, 16.0, 10.0).withColor(3899647)};

    public CommutatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        VoxelShaper baseShaper = VoxelShaper.forHorizontalAxis((VoxelShape)Shapes.m_83124_((VoxelShape)CommutatorBlock.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0), (VoxelShape[])new VoxelShape[]{CommutatorBlock.m_49796_((double)0.0, (double)12.0, (double)6.0, (double)3.0, (double)16.0, (double)9.0), CommutatorBlock.m_49796_((double)13.0, (double)12.0, (double)7.0, (double)16.0, (double)16.0, (double)10.0)}), (Direction.Axis)Direction.Axis.Z);
        this.terminals = BlockStateTerminalCollection.builder(this).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            return BlockStateTerminalCollection.each(TERMINALS_HORIZONTAL, terminal -> terminal.rotateAroundY((int)facing.m_122435_() - 180));
        }, new Property[0]).withShapeMapper(state -> {
            Direction.Axis axis = ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_();
            return baseShaper.get(axis);
        }).build();
        this.outlines = this.m_152458_(this.terminals.shapeMapper());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.outlines.get((Object)state);
    }

    public Class<CommutatorBlockEntity> getBlockEntityClass() {
        return CommutatorBlockEntity.class;
    }

    public BlockEntityType<? extends CommutatorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.GENERATOR_COMMUTATOR.get();
    }

    @Override
    public int terminalCount() {
        return 2;
    }

    @Override
    public ITerminalPlacement terminal(BlockState state, int index) {
        return this.terminals.get(state, index);
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        if (result == InteractionResult.SUCCESS && !context.m_43725_().f_46443_) {
            ElectricBlock.refreshConnectionEntities(context.m_43725_(), context.m_8083_());
        }
        return result;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction.Axis preferredAxis = null;
        for (Direction.Axis axis : Directions.HORIZONTAL_AXIS) {
            if (!CommutatorBlock.hasPositive((LevelReader)world, pos, axis) && !CommutatorBlock.hasNegative((LevelReader)world, pos, axis)) continue;
            if (preferredAxis != null) {
                preferredAxis = null;
                break;
            }
            preferredAxis = axis;
        }
        Direction facing = null;
        if (preferredAxis != null) {
            for (Direction dir : context.m_6232_()) {
                if (dir.m_122434_() != preferredAxis) continue;
                facing = dir;
                break;
            }
        }
        if (facing == null) {
            facing = context.m_8125_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)facing);
    }

    @Override
    public boolean canConnect(BlockState state, Direction dir) {
        return ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() == dir.m_122434_();
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Direction.Axis getAssemblyRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_();
    }

    @Override
    public Vec3 brushOffset(BlockState state) {
        return switch (((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_()) {
            case Direction.Axis.Z -> new Vec3(0.21875, 0.0, 0.125);
            case Direction.Axis.X -> new Vec3(-0.125, 0.0, 0.21875);
            default -> throw new IllegalStateException();
        };
    }

    @Override
    public Vec3 sparkVelocity(BlockState state, float angularVelocity) {
        return switch (((Direction)state.m_61143_((Property)HORIZONTAL_FACING)).m_122434_()) {
            case Direction.Axis.Z -> new Vec3(0.0, (double)(0.25f + Math.abs(angularVelocity) / 100.0f), 0.0);
            case Direction.Axis.X -> new Vec3(0.0, (double)(-0.25f - Math.abs(angularVelocity) / 100.0f), 0.0);
            default -> throw new IllegalStateException();
        };
    }
}

