/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.ponder.scenes;

import com.tterrag.registrate.util.entry.BlockEntry;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.scene.PonderStoryBoard;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.electricswitch.HvSwitchBlockEntity;
import org.patryk3211.powergrid.electricity.electricswitch.SurfaceSwitchBlock;
import org.patryk3211.powergrid.electricity.fuse.FuseHolderBlock;
import org.patryk3211.powergrid.electricity.fuse.FuseState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.kinetics.rheostat.RheostatBlockEntity;
import org.patryk3211.powergrid.kinetics.variac.VariacBlockEntity;
import org.patryk3211.powergrid.ponder.base.ElectricInstructions;
import org.patryk3211.powergrid.ponder.base.PowerGridSceneBuilder;

public class RelayScenes {
    public static PonderStoryBoard switchSceneFor(BlockEntry<? extends SurfaceSwitchBlock> block, String suffix) {
        return (scene, util) -> RelayScenes.switchScene(scene, util, (SurfaceSwitchBlock)block.get(), suffix);
    }

    public static void switchScene(SceneBuilder scene, SceneBuildingUtil util, SurfaceSwitchBlock block, String suffix) {
        ElectricInstructions electric = ElectricInstructions.of(scene);
        scene.title("switch_" + suffix, "Manually switching electricity");
        scene.configureBasePlate(0, 0, 5);
        BlockPos source = util.grid().at(2, 1, 3);
        BlockPos target = util.grid().at(1, 2, 2);
        BlockPos bulb = util.grid().at(3, 2, 2);
        scene.world().setBlock(target, (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN)).m_61124_((Property)CustomProperties.ALONG_FIRST_AXIS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true)), false);
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 4, 1, 2), Direction.DOWN);
        scene.world().showSection(util.select().position(0, 2, 2), Direction.DOWN);
        scene.world().showSection(util.select().position(4, 2, 2), Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(util.select().position(1, 2, 2), Direction.DOWN);
        scene.world().showSection(util.select().position(3, 2, 2), Direction.DOWN);
        scene.idle(10);
        electric.connectInvisible(util.grid().at(0, 2, 2), 0, source, 0);
        electric.connectInvisible(util.grid().at(4, 2, 2), 0, source, 1);
        electric.connect(util.grid().at(0, 2, 2), 0, target, 1);
        electric.connect(util.grid().at(4, 2, 2), 0, bulb, 0);
        electric.connect(target, 0, bulb, 1);
        scene.idle(10);
        scene.overlay().showText(80).text("Switches and buttons allow you to manually toggle electricity").pointAt(util.vector().centerOf(target)).placeNearTarget().attachKeyFrame();
        scene.idle(50);
        scene.world().modifyBlock(target, state -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false)), false);
        scene.world().modifyBlock(bulb, state -> (BlockState)state.m_61124_((Property)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(2)), false);
        scene.effects().indicateSuccess(target);
        if (block.isButton()) {
            scene.idle(10);
            scene.world().modifyBlock(target, state -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true)), false);
            scene.world().modifyBlock(bulb, state -> (BlockState)state.m_61124_((Property)LightFixtureBlock.POWER, (Comparable)Integer.valueOf(0)), false);
            scene.idle(30);
        } else {
            scene.idle(40);
        }
        scene.markAsFinished();
        electric.unload();
    }

    public static void hvSwitch(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("hv_switch", "Mechanical switch");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world().showSection(util.select().position(2, 0, 5), Direction.UP);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 1, 2, 5), Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(util.select().position(1, 1, 2), Direction.DOWN);
        scene.world().showSection(util.select().position(2, 1, 2), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(80).text("The High Voltage Switch allows you to toggle electricity using a kinetic input").pointAt(util.vector().topOf(1, 1, 2)).placeNearTarget().attachKeyFrame();
        scene.idle(50);
        scene.world().toggleRedstonePower(util.select().fromTo(1, 1, 3, 1, 2, 3));
        scene.world().modifyBlockEntity(util.grid().at(1, 1, 2), HvSwitchBlockEntity.class, be -> {
            be.setSpeed(-64.0f);
            be.onSpeedChanged(64.0f);
        });
        scene.idle(40);
        scene.markAsFinished();
    }

    public static void contactor(SceneBuilder scene, SceneBuildingUtil util) {
        ElectricInstructions electric = ElectricInstructions.of(scene);
        scene.title("contactor", "Heavy-duty relay");
        scene.configureBasePlate(0, 0, 5);
        BlockPos target = util.grid().at(2, 2, 2);
        BlockPos meter1 = util.grid().at(2, 1, 1);
        BlockPos meter2 = util.grid().at(0, 1, 2);
        BlockPos source1 = util.grid().at(2, 1, 0);
        BlockPos source2 = util.grid().at(4, 1, 2);
        BlockPos connector = util.grid().at(2, 2, 1);
        scene.showBasePlate();
        scene.world().showSection(util.select().position(2, 1, 2), Direction.UP);
        scene.idle(10);
        scene.world().showSection(util.select().position(4, 1, 1), Direction.DOWN);
        scene.world().showSection(util.select().position(4, 1, 3), Direction.DOWN);
        scene.world().showSection(util.select().position(0, 1, 2), Direction.DOWN);
        scene.world().showSection(util.select().position(2, 1, 1), Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 2, 2), Direction.DOWN);
        scene.world().showSection(util.select().position(2, 2, 1), Direction.DOWN);
        scene.idle(10);
        electric.connectInvisible(source1, 1, connector, 1);
        electric.connectInvisible(source1, 0, connector, 0);
        electric.connectInvisible(source2, 0, util.grid().at(4, 1, 1), 0);
        electric.connectInvisible(source2, 1, util.grid().at(4, 1, 3), 0);
        electric.connect(connector, 0, meter1, 1);
        electric.connect(connector, 1, meter1, 0);
        electric.connect(util.grid().at(4, 1, 1), 0, target, 2);
        electric.connect(util.grid().at(4, 1, 3), 0, target, 4);
        electric.connect(target, 3, meter2, 0);
        electric.connect(target, 5, meter2, 1);
        scene.idle(10);
        scene.overlay().showText(80).text("A Contactor lets you switch high currents with a lower voltage input.").pointAt(util.vector().topOf(target)).placeNearTarget().attachKeyFrame();
        scene.idle(40);
        electric.setSource(source1, 25.0f);
        electric.tickFor(10);
        scene.idle(5);
        scene.effects().indicateSuccess(meter2);
        scene.idle(45);
        scene.markAsFinished();
        electric.unload();
    }

    public static void contactorStack(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("contactor_stack", "Electrical Switchboard");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        BlockPos target = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().position(target), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(60).text("Contactors can be stacked together").pointAt(util.vector().blockSurface(target, Direction.NORTH)).placeNearTarget().attachKeyFrame();
        scene.idle(70);
        scene.world().showSection(util.select().position(target.m_122012_()), Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(util.select().position(target.m_122019_()), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(60).text("And only one needs to be powered").pointAt(util.vector().blockSurface(target.m_122012_(), Direction.NORTH)).placeNearTarget().attachKeyFrame();
        scene.idle(40);
        scene.world().showSection(util.select().position(target.m_122013_(2)), Direction.SOUTH);
        scene.idle(30);
        scene.markAsFinished();
    }

    public static void variac(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("variac", "Variable transformer");
        scene.configureBasePlate(0, 0, 5);
        BlockPos source = util.grid().at(3, 1, 2);
        BlockPos meter1 = util.grid().at(3, 1, 1);
        BlockPos meter2 = util.grid().at(1, 1, 1);
        BlockPos target = util.grid().at(2, 2, 2);
        scene.showBasePlate();
        scene.world().showSection(util.select().position(2, 1, 2), Direction.UP);
        scene.idle(10);
        scene.world().showSection(util.select().position(meter1), Direction.DOWN);
        scene.world().showSection(util.select().position(meter2), Direction.DOWN);
        scene.world().showSection(util.select().fromTo(target, target.m_7494_()), Direction.DOWN);
        scene.idle(10);
        scene.electric().connectInvisible(source, 0, meter1, 0);
        scene.electric().connectInvisible(source, 1, meter1, 1);
        scene.electric().connect(meter1, 0, target, 0);
        scene.electric().connect(meter1, 1, target, 1);
        scene.electric().connect(meter2, 0, target, 1);
        scene.electric().connect(meter2, 1, target, 2);
        scene.electric().setSource(source, 160.0f);
        scene.electric().tickFor(10);
        scene.idle(10);
        scene.overlay().showText(80).text("A variac can be used to variably transform voltages using a kinetic input").pointAt(util.vector().blockSurface(target, Direction.NORTH)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.world().setKineticSpeed(util.select().fromTo(target, target.m_7494_()), 16.0f);
        scene.world().modifyBlockEntity(target, VariacBlockEntity.class, be -> be.onSpeedChanged(0.0f));
        scene.effects().rotationSpeedIndicator(target.m_7494_());
        scene.electric().tickFor(40);
        scene.idle(40);
        scene.world().setKineticSpeed(util.select().fromTo(target, target.m_7494_()), 0.0f);
        scene.world().modifyBlockEntity(target, VariacBlockEntity.class, be -> be.onSpeedChanged(16.0f));
        scene.markAsFinished();
    }

    public static void rheostat(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("rheostat", "Variable resistor");
        scene.configureBasePlate(0, 0, 5);
        BlockPos source = util.grid().at(3, 1, 2);
        BlockPos meter1 = util.grid().at(3, 1, 1);
        BlockPos meter2 = util.grid().at(1, 1, 1);
        BlockPos target = util.grid().at(2, 2, 2);
        scene.showBasePlate();
        scene.world().showSection(util.select().position(2, 1, 2), Direction.UP);
        scene.idle(10);
        scene.world().showSection(util.select().position(meter1), Direction.DOWN);
        scene.world().showSection(util.select().position(meter2), Direction.DOWN);
        scene.world().showSection(util.select().fromTo(target, target.m_7494_()), Direction.DOWN);
        scene.idle(10);
        scene.electric().connectInvisible(source, 0, meter1, 0);
        scene.electric().connectInvisible(source, 1, meter1, 1);
        scene.electric().connect(meter1, 0, target, 0);
        scene.electric().connect(meter1, 1, target, 2);
        scene.electric().connect(meter2, 0, target, 1);
        scene.electric().connect(meter2, 1, target, 2);
        scene.electric().setSource(source, 20.0f);
        scene.electric().tickFor(10);
        scene.idle(10);
        scene.overlay().showText(80).text("A rheostat can be used to vary electrical resistance using a kinetic input").pointAt(util.vector().blockSurface(target, Direction.NORTH)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.world().setKineticSpeed(util.select().fromTo(target, target.m_7494_()), -16.0f);
        scene.world().modifyBlockEntity(target, RheostatBlockEntity.class, be -> be.onSpeedChanged(0.0f));
        scene.effects().rotationSpeedIndicator(target.m_7494_());
        scene.electric().tickFor(40);
        scene.idle(40);
        scene.world().setKineticSpeed(util.select().fromTo(target, target.m_7494_()), 0.0f);
        scene.world().modifyBlockEntity(target, RheostatBlockEntity.class, be -> be.onSpeedChanged(-16.0f));
        scene.markAsFinished();
    }

    public static void powerResistor(SceneBuilder builder, SceneBuildingUtil util) {
        PowerGridSceneBuilder scene = new PowerGridSceneBuilder(builder);
        scene.title("power_resistor", "High-power resistor");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        BlockPos target = util.grid().at(2, 2, 2);
        scene.world().showSection(util.select().fromTo(target.m_7495_(), target), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(80).text("The Power Resistor is a simple device which lets you limit the current flow in a circuit.").pointAt(util.vector().blockSurface(target, Direction.NORTH)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.overlay().showText(60).text("You can change the resistance by clicking on its top").pointAt(util.vector().topOf(target)).placeNearTarget().attachKeyFrame();
        scene.idle(70);
        BlockPos connector1 = util.grid().at(0, 2, 2);
        BlockPos connector2 = util.grid().at(4, 2, 2);
        BlockPos gauge = util.grid().at(1, 1, 1);
        scene.world().showSection(util.select().fromTo(connector1.m_7495_(), connector1), Direction.EAST);
        scene.world().showSection(util.select().fromTo(connector2.m_7495_(), connector2), Direction.WEST);
        scene.idle(5);
        scene.world().showSection(util.select().position(gauge), Direction.DOWN);
        scene.idle(5);
        scene.electric().connect(connector1, 0, gauge, 1);
        scene.electric().connect(gauge, 0, target, 1);
        scene.electric().connect(connector2, 0, target, 0);
        scene.idle(5);
        scene.electric().addSource(connector1, 0, 1.0f);
        scene.electric().addSource(connector2, 0, 0.0f);
        scene.electric().tickFor(20);
        scene.overlay().showText(80).text("The current flow is equal to the voltage across the resistor divided by its resistance (I = V / R)").pointAt(util.vector().blockSurface(gauge, Direction.NORTH)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void deviceConnector(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("device_connector", "Device connector");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        BlockPos target = util.grid().at(2, 2, 2);
        scene.world().showSection(util.select().position(2, 1, 2), Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(60).text("Some devices don't directly expose their electrical terminals").pointAt(util.vector().blockSurface(util.grid().at(2, 1, 2), Direction.NORTH)).placeNearTarget().attachKeyFrame();
        scene.idle(70);
        scene.world().showSection(util.select().position(target), Direction.DOWN);
        scene.idle(5);
        scene.effects().indicateSuccess(target.m_7495_());
        scene.idle(10);
        scene.overlay().showText(80).text("To power them, you'll have to place a Device Connector and attach your wires to it").pointAt(util.vector().centerOf(target)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.overlay().showText(80).text("The Device Connector can also be used to power Forge Energy and Create: The Factory Must Grow devices (if installed)").placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.markAsFinished();
    }

    public static void fuse(SceneBuilder scene, SceneBuildingUtil util) {
        ElectricInstructions electric = ElectricInstructions.of(scene);
        scene.title("fuse", "Protecting your equipment");
        scene.configureBasePlate(0, 0, 5);
        BlockPos target = util.grid().at(2, 1, 2);
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().position(0, 1, 2), Direction.DOWN);
        scene.world().showSection(util.select().position(4, 1, 2), Direction.DOWN);
        scene.idle(10);
        scene.world().showSection(util.select().position(target), Direction.DOWN);
        scene.idle(10);
        electric.connect(util.grid().at(0, 1, 2), 0, target, 1);
        electric.connect(util.grid().at(4, 1, 2), 0, target, 0);
        scene.idle(10);
        scene.overlay().showControls(util.vector().centerOf(target), Pointing.LEFT, 40).rightClick().withItem(ModdedItems.IRON_WIRE.asStack());
        scene.idle(30);
        scene.world().modifyBlock(target, state -> (BlockState)state.m_61124_(FuseHolderBlock.STATE, (Comparable)((Object)FuseState.CLOSED)), false);
        scene.idle(20);
        scene.overlay().showText(80).text("A fuse can be used to protect your devices from too much current").pointAt(util.vector().centerOf(target)).placeNearTarget().attachKeyFrame();
        scene.idle(90);
        scene.overlay().showText(80).text("It will burn if the current exceeds the set value").pointAt(util.vector().centerOf(target)).placeNearTarget().attachKeyFrame();
        scene.idle(40);
        scene.world().modifyBlock(target, state -> (BlockState)state.m_61124_(FuseHolderBlock.STATE, (Comparable)((Object)FuseState.BLOWN)), false);
        scene.addInstruction(pScene -> {
            Vec3 pos = util.vector().centerOf(target);
            SparkParticleData.explodeParticles((Level)pScene.getWorld(), (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, Direction.UP, 5);
        });
        scene.idle(50);
        scene.markAsFinished();
        electric.unload();
    }
}

