/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility;

import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.network.chat.Component;
import org.patryk3211.powergrid.utility.Lang;

public enum Unit {
    VOLTAGE("generic.unit.volt"),
    CURRENT("generic.unit.amp"),
    POWER("generic.unit.watt"),
    RESISTANCE("generic.unit.ohm"),
    TEMPERATURE("generic.unit.temperature");

    private final String translationKey;

    private Unit(String translationKey) {
        this.translationKey = translationKey;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public LangBuilder get() {
        return Lang.unit(this);
    }

    public String string() {
        return this.get().string();
    }

    public LangBuilder formatWithPrefixes(double value) {
        LangBuilder valueText = Lang.builder();
        if (Math.abs(value) < 1.0) {
            valueText.add(Lang.number(value * 1000.0)).add(Component.m_130674_((String)" m")).add(this.get());
        } else if (Math.abs(value) < 1000.0) {
            valueText.add(Lang.number(value)).add(Component.m_130674_((String)" ")).add(this.get());
        } else if (Math.abs(value) < 1000000.0) {
            valueText.add(Lang.number(value / 1000.0)).add(Component.m_130674_((String)" k")).add(this.get());
        } else {
            valueText.add(Lang.number(value / 1000000.0)).add(Component.m_130674_((String)" M")).add(this.get());
        }
        return valueText;
    }

    public Component format(double v) {
        return Lang.number(v).add(Component.m_237113_((String)" ")).add(this.get()).component();
    }
}

