/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electricswitch;

import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.electricswitch.SurfaceSwitchBlock;

public class LvSwitchBlock
extends SurfaceSwitchBlock {
    private static final TerminalBoundingBox[] DOWN_TERMINALS = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 7.0, 0.0, 1.0, 9.0, 2.0, 3.0), new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 7.0, 0.0, 13.0, 9.0, 2.0, 15.0)};
    private static final VoxelShape SHAPE_DOWN = LvSwitchBlock.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)3.0, (double)13.0);
    private static final VoxelShape SHAPE_DOWN_2 = LvSwitchBlock.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)3.0, (double)12.0);

    public LvSwitchBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.maxVoltage = 320.0f;
        VoxelShaper shaper = VoxelShaper.forDirectional((VoxelShape)SHAPE_DOWN, (Direction)Direction.DOWN);
        VoxelShaper shaper2 = VoxelShaper.forDirectional((VoxelShape)SHAPE_DOWN_2, (Direction)Direction.DOWN);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStatesExcept(state -> BlockStateTerminalCollection.each(DOWN_TERMINALS, terminal -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            switch (facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DOWN: {
                    TerminalBoundingBox terminalBoundingBox = terminal;
                    break;
                }
                case UP: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundX(180);
                    break;
                }
                case EAST: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundZ(-90);
                    break;
                }
                case WEST: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundZ(90);
                    break;
                }
                case NORTH: {
                    TerminalBoundingBox terminalBoundingBox = terminal.rotateAroundZ(90).rotateAroundY(90);
                    break;
                }
                case SOUTH: {
                    TerminalBoundingBox terminalBoundingBox = terminal = terminal.rotateAroundZ(90).rotateAroundY(-90);
                }
            }
            if (!((Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS)).booleanValue()) {
                terminal = terminal.rotate(facing.m_122434_(), 90);
            }
            return terminal;
        }), new Property[]{OPEN}).withShapeMapper(state -> {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            Boolean axis_along = (Boolean)state.m_61143_((Property)ALONG_FIRST_AXIS);
            VoxelShaper prov = axis_along ^ facing.m_122434_() == Direction.Axis.Y ? shaper2 : shaper;
            return prov.get(facing);
        }).build());
    }

    @Override
    public void useSound(Level world, BlockPos pos, boolean open) {
        world.m_5594_(null, pos, ModdedSoundEvents.LV_SWITCH_CLICK.getMainEvent(), SoundSource.BLOCKS, 0.3f, open ? 0.65f : 0.75f);
    }
}

