/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electricswitch;

import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.electricswitch.SwitchBlockEntity;
import org.patryk3211.powergrid.electricity.info.Current;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.electricity.wire.IWire;

public abstract class SwitchBlock
extends ElectricBlock
implements IBE<SwitchBlockEntity>,
IHaveElectricProperties {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected float maxVoltage = 200.0f;
    protected boolean isButton = false;

    public SwitchBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    public boolean isButton() {
        return this.isButton;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_6144_() && !IWire.holdsWire(player)) {
            boolean isOpen;
            boolean bl = isOpen = (Boolean)state.m_61143_((Property)OPEN) == false;
            if (!this.isButton) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(isOpen)));
                this.withBlockEntityDo((BlockGetter)world, pos, be -> be.setState(!isOpen));
                this.useSound(world, pos, isOpen);
            } else {
                if (!isOpen) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
                    this.useSound(world, pos, false);
                }
                this.withBlockEntityDo((BlockGetter)world, pos, be -> be.setState(true));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void useSound(Level world, BlockPos pos, boolean open) {
    }

    public Class<SwitchBlockEntity> getBlockEntityClass() {
        return SwitchBlockEntity.class;
    }

    public BlockEntityType<? extends SwitchBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModdedBlockEntities.SWITCH.get();
    }

    public float getMaxVoltage() {
        return this.maxVoltage;
    }

    @Override
    public void appendProperties(ItemStack stack, Player player, List<Component> tooltip) {
        Resistance.series(this.resistance(), player, tooltip);
        Current.max(stack, player, tooltip);
        Voltage.max(this.maxVoltage, player, tooltip);
    }
}

