/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.gauge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.electricity.gauge.CurrentGaugeBlockEntity;
import org.patryk3211.powergrid.electricity.gauge.GaugeBlockEntity;
import org.patryk3211.powergrid.electricity.gauge.IGaugeBlock;
import org.patryk3211.powergrid.electricity.gauge.PowerGaugeBlockEntity;

public class GaugeRenderer
extends SafeBlockEntityRenderer<GaugeBlockEntity> {
    public GaugeRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(GaugeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState gaugeState = be.m_58900_();
        SuperByteBuffer headBuffer = CachedBuffers.partial((PartialModel)GaugeRenderer.getHeadModel(gaugeState, be), (BlockState)gaugeState);
        SuperByteBuffer dialBuffer = CachedBuffers.partial((PartialModel)GaugeRenderer.getDialModel(gaugeState), (BlockState)gaugeState);
        float progress = Mth.m_14179_((float)partialTicks, (float)be.prevDialState, (float)be.dialState);
        for (Direction facing : Iterate.directions) {
            if (!((IGaugeBlock)gaugeState.m_60734_()).shouldRenderHeadOnFace(be.m_58904_(), be.m_58899_(), gaugeState, facing)) continue;
            float dialPivot = 0.359375f;
            VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
            ((SuperByteBuffer)((SuperByteBuffer)this.rotateBufferTowards(dialBuffer, facing).translate(0.0f, dialPivot, dialPivot)).rotate(Direction.EAST.m_122434_(), (float)(1.5707963267948966 * (double)(-progress))).translate(0.0f, -dialPivot, -dialPivot)).light(light).renderInto(ms, vb);
            this.rotateBufferTowards(headBuffer, facing).light(light).renderInto(ms, vb);
        }
    }

    protected SuperByteBuffer rotateBufferTowards(SuperByteBuffer buffer, Direction target) {
        return (SuperByteBuffer)buffer.rotateCentered((float)((double)((-target.m_122435_() - 90.0f) / 180.0f) * Math.PI), Direction.UP);
    }

    public static PartialModel getHeadModel(BlockState state, GaugeBlockEntity entity) {
        if (entity instanceof PowerGaugeBlockEntity) {
            return ModdedPartialModels.CONDUCTIVE_POWER_HEAD;
        }
        if (entity instanceof CurrentGaugeBlockEntity) {
            return ModdedPartialModels.CONDUCTIVE_CURRENT_HEAD;
        }
        return ModdedPartialModels.CONDUCTIVE_VOLTAGE_HEAD;
    }

    public static PartialModel getDialModel(BlockState state) {
        return AllPartialModels.GAUGE_DIAL;
    }
}

