/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.Collection;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.BakedCircuit;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;

public class CircuitBoardEndpoint
implements IWireEndpoint {
    private BlockPos pos;
    private int x;
    private int y;

    public CircuitBoardEndpoint() {
        this(null, 0, 0);
    }

    public CircuitBoardEndpoint(BlockPos pos, int x, int y) {
        this.pos = pos;
        this.x = x;
        this.y = y;
    }

    @Override
    public WireEndpointType type() {
        return WireEndpointType.CIRCUIT_BOARD;
    }

    @Override
    public void read(CompoundTag nbt) {
        int[] posArr = nbt.m_128465_("Pos");
        this.pos = new BlockPos(posArr[0], posArr[1], posArr[2]);
        this.x = nbt.m_128445_("X");
        this.y = nbt.m_128445_("Y");
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128385_("Pos", new int[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()});
        nbt.m_128344_("X", (byte)this.x);
        nbt.m_128344_("Y", (byte)this.y);
    }

    @Override
    @NotNull
    public Vec3 getExactPosition(Level world) {
        Vec3 pos = new Vec3((double)(((float)this.x + 0.5f) / 16.0f), 0.125, (double)(((float)this.y + 0.5f) / 16.0f));
        BlockState state = world.m_8055_(this.pos);
        pos = VecHelper.rotateCentered((Vec3)pos, (double)CircuitBoardBlock.getAngleX(state), (Direction.Axis)Direction.Axis.X);
        pos = VecHelper.rotateCentered((Vec3)pos, (double)CircuitBoardBlock.getAngleY(state), (Direction.Axis)Direction.Axis.Y);
        return pos.m_82520_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_());
    }

    @Override
    public boolean isValid(Level world) {
        Optional opt = world.m_141902_(this.pos, (BlockEntityType)ModdedBlockEntities.CIRCUIT_BOARD.get());
        return opt.map(be -> be.getSchematic().front().get(this.x, this.y)).orElse(false);
    }

    public IElectricNode getGenericNode(Level world) {
        Optional opt = world.m_141902_(this.pos, (BlockEntityType)ModdedBlockEntities.CIRCUIT_BOARD.get());
        return opt.map(be -> {
            BakedCircuit baked = be.getBaked();
            if (baked == null) {
                return null;
            }
            Collection<CircuitSchematic.Node> bundle = be.getSchematic().flood(CircuitSchematic.Layer.FRONT, this.x, this.y, new CircuitSchematic.VisitMap());
            if (bundle.isEmpty()) {
                return null;
            }
            CircuitSchematic.Node node = bundle.iterator().next();
            return baked.getNode(node);
        }).orElse(null);
    }
}

