/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.patryk3211.powergrid.AbstractPowerGridRegistrate;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.components.ComponentRegistry;
import org.patryk3211.powergrid.circuits.components.forge.ComponentRegistryImpl;
import org.patryk3211.powergrid.collections.ItemDisplay;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.collections.forge.ModdedSoundEventsImpl;
import org.patryk3211.powergrid.commands.PerformanceCommand;
import org.patryk3211.powergrid.compat.tfmg.TFMGBridge;
import org.patryk3211.powergrid.compat.tfmg.TFMGProxyImpl;
import org.patryk3211.powergrid.data.BlockTagProvider;
import org.patryk3211.powergrid.data.ItemTagProvider;
import org.patryk3211.powergrid.data.recipe.forge.MixingRecipes;
import org.patryk3211.powergrid.data.recipe.forge.SequencedAssemblyRecipes;
import org.patryk3211.powergrid.data.recipes.CookingRecipes;
import org.patryk3211.powergrid.data.recipes.CraftingRecipes;
import org.patryk3211.powergrid.data.recipes.CuttingRecipes;
import org.patryk3211.powergrid.data.recipes.DeployerApplicationRecipes;
import org.patryk3211.powergrid.data.recipes.ItemApplicationRecipes;
import org.patryk3211.powergrid.data.recipes.MagnetizingRecipes;
import org.patryk3211.powergrid.data.recipes.MechanicalCraftingRecipes;
import org.patryk3211.powergrid.data.recipes.PressingRecipes;
import org.patryk3211.powergrid.electricity.deviceconnector.DeviceConnectorBlockEntity;
import org.patryk3211.powergrid.forge.ElectricProperties;
import org.patryk3211.powergrid.forge.ForgeEvents;
import org.patryk3211.powergrid.forge.ForgePowerGridRegistrate;
import org.patryk3211.powergrid.forge.PowerGridClientImpl;
import org.patryk3211.powergrid.ponder.PowerGridPonderPlugin;
import org.patryk3211.powergrid.utility.proxy.ProxyProvider;
import org.patryk3211.powergrid.utility.proxy.TFMGProxy;

@Mod(value="powergrid")
public class PowerGridImpl {
    public static ModLoadingContext context;
    public static IEventBus bus;
    public static final DeferredRegister<CreativeModeTab> TABS;
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;

    public PowerGridImpl() {
        context = ModLoadingContext.get();
        bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register(PowerGridImpl.class);
        EventBuses.registerModEventBus((String)"powergrid", (IEventBus)bus);
        if (Platform.isModLoaded((String)"tfmg")) {
            TFMGBridge.init();
            ProxyProvider.add(TFMGProxy.class, new TFMGProxyImpl());
        }
        PowerGrid.init();
        TABS.register("main", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack(ModdedItems.WIRE)).m_257501_((CreativeModeTab.DisplayItemsGenerator)new ItemDisplay.BaseItemDisplay(true)).m_257941_((Component)Component.m_237115_((String)"itemGroup.powergrid.main")).m_257652_());
        COMMAND_ARGUMENT_TYPES.register("performance_counter", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(PerformanceCommand.PerformanceCounterArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(PerformanceCommand.PerformanceCounterArgument::new)));
        PowerGrid.REGISTRATE.addLang("itemGroup", PowerGrid.asResource("main"), "Power Grid");
        TABS.register(bus);
        COMMAND_ARGUMENT_TYPES.register(bus);
        MinecraftForge.EVENT_BUS.register(ForgeEvents.class);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> PowerGridClientImpl::init);
    }

    @SubscribeEvent
    public static void newRegistryEvent(NewRegistryEvent event) {
        event.create(RegistryBuilder.of((ResourceLocation)ComponentRegistry.REGISTRY_KEY.m_135782_()), registry -> {
            ComponentRegistryImpl.REGISTRY = registry;
        });
    }

    @SubscribeEvent
    public static void configLoad(ModConfigEvent.Loading event) {
        ModdedConfigs.onLoad(event.getConfig());
    }

    @SubscribeEvent
    public static void configReload(ModConfigEvent.Reloading event) {
        ModdedConfigs.onReload(event.getConfig());
    }

    @SubscribeEvent
    public static void soundEventRegister(RegisterEvent event) {
        event.register(Registries.f_256840_, ModdedSoundEventsImpl::register);
    }

    @SubscribeEvent
    public static void imcEnqueue(InterModEnqueueEvent event) {
        List<BlockEntityEntry<DeviceConnectorBlockEntity>> forbiddenBlockEntities = List.of(ModdedBlockEntities.GENERATOR_CLUTCH, ModdedBlockEntities.GENERATOR_INDUCTION_ROTOR, ModdedBlockEntities.GENERATOR_COMMUTATOR, ModdedBlockEntities.WINDING, ModdedBlockEntities.TRANSFORMER_MEDIUM, ModdedBlockEntities.HV_SWITCH, ModdedBlockEntities.DEVICE_CONNECTOR);
        forbiddenBlockEntities.stream().map(entry -> entry.getId().toString()).forEach(id -> InterModComms.sendTo((String)"carryon", (String)"blacklistBlock", () -> id));
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        PowerGrid.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            PowerGridImpl.provideDefaultLang("interface", langConsumer);
            PowerGridImpl.provideDefaultLang("messages", langConsumer);
            PowerGridImpl.provideDefaultLang("tooltips", langConsumer);
            PowerGridImpl.providePonderLang(langConsumer);
            ModdedSoundEvents.provideLang(langConsumer);
        });
        generator.addProvider(true, (DataProvider)new CookingRecipes(output));
        generator.addProvider(true, (DataProvider)new CraftingRecipes(output));
        generator.addProvider(true, (DataProvider)new CuttingRecipes(output));
        generator.addProvider(true, (DataProvider)new ItemApplicationRecipes(output));
        generator.addProvider(true, (DataProvider)new MagnetizingRecipes(output));
        generator.addProvider(true, (DataProvider)new MechanicalCraftingRecipes(output));
        generator.addProvider(true, (DataProvider)new MixingRecipes(output));
        generator.addProvider(true, (DataProvider)new PressingRecipes(output));
        generator.addProvider(true, (DataProvider)new org.patryk3211.powergrid.data.recipes.SequencedAssemblyRecipes(output));
        generator.addProvider(true, (DataProvider)new SequencedAssemblyRecipes(output));
        generator.addProvider(true, (DataProvider)new DeployerApplicationRecipes(output));
        generator.addProvider(true, (DataProvider)new BlockTagProvider(output, event.getLookupProvider()));
        generator.addProvider(true, (DataProvider)new ItemTagProvider(output, event.getLookupProvider()));
        generator.addProvider(true, ModdedSoundEvents.provider(output));
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/powergrid/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new PowerGridPonderPlugin());
        PonderIndex.getLangAccess().provideLang("powergrid", consumer);
    }

    public static AbstractPowerGridRegistrate createRegistrate() {
        return ForgePowerGridRegistrate.create("powergrid").setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))).andThen(TooltipModifier.mapNull((TooltipModifier)ElectricProperties.create(item))));
    }

    public static void finalizeRegistrate() {
        ((ForgePowerGridRegistrate)PowerGrid.REGISTRATE).registerEventListeners(bus);
    }

    static {
        TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"powergrid");
        COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"powergrid");
    }
}

