/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.PropertyEntry;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class UpdateComponentBiPacket
implements SimplePacket {
    private final BlockPos pos;
    private final int componentId;
    private final ResourceLocation propertyId;
    private final CompoundTag propertyValue;

    public UpdateComponentBiPacket(CircuitBoardBlockEntity be, PlacedComponent component, ComponentProperty<?> property) {
        this.pos = be.m_58899_();
        this.componentId = be.getSchematic().getId(component);
        assert (this.componentId >= 0);
        this.propertyId = property.id();
        this.propertyValue = new CompoundTag();
        component.getEntry(property).write(this.propertyValue);
    }

    public UpdateComponentBiPacket(CircuitBoardBlockEntity be, PlacedComponent component, ResourceLocation propertyId) {
        this.pos = be.m_58899_();
        this.componentId = be.getSchematic().getId(component);
        assert (this.componentId >= 0);
        this.propertyId = propertyId;
        this.propertyValue = new CompoundTag();
        component.getEntry(propertyId).write(this.propertyValue);
    }

    public UpdateComponentBiPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.componentId = buf.readInt();
        this.propertyId = buf.m_130281_();
        this.propertyValue = buf.m_130260_();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.componentId);
        buf.m_130085_(this.propertyId);
        buf.m_130079_(this.propertyValue);
    }

    public void handle(Level world) {
        Optional be = world.m_141902_(this.pos, (BlockEntityType)ModdedBlockEntities.CIRCUIT_BOARD.get());
        be.ifPresent(circuit -> {
            PlacedComponent placed = circuit.getSchematic().components().get(this.componentId);
            PropertyEntry<?> entry = placed.getEntry(this.propertyId);
            entry.read(this.propertyValue);
            placed.stateUpdated();
            if (!world.f_46443_) {
                placed.notifyClients(this.propertyId);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        Level world = ClientSideAccess.world();
        this.handle(world);
    }

    public void handleServer(Player player) {
        Level world = player.m_9236_();
        if (!player.m_142265_(world, this.pos)) {
            return;
        }
        this.handle(world);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            switch (ctx.getEnv()) {
                case CLIENT: {
                    this.handleClient();
                    break;
                }
                case DEDICATED_SERVER: {
                    this.handleServer(ctx.getPlayer());
                }
            }
        });
    }
}

