/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.circuitboard;

import java.util.HashMap;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedBlocks;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.utility.Lang;

public class IncompleteCircuitItem
extends class_1792 {
    public IncompleteCircuitItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1));
    }

    private static class_2487 makeAssemblyTag(class_2487 schematicTag) {
        CircuitSchematic schematic = CircuitSchematic.fromNbt(schematicTag);
        HashMap<class_1792, Integer> componentAmounts = new HashMap<class_1792, Integer>();
        int componentCount = 0;
        for (PlacedComponent placed : schematic.components()) {
            class_1792 item2 = placed.component.getRequiredItem();
            componentAmounts.compute(item2, (key, current) -> current == null ? 1 : current + 1);
            ++componentCount;
        }
        class_2487 componentTag = new class_2487();
        componentAmounts.forEach((item, count) -> {
            class_2960 id = class_7923.field_41178.method_10221(item);
            componentTag.method_10569(id.toString(), count.intValue());
        });
        class_2487 assemblyTag = new class_2487();
        assemblyTag.method_10566("Missing", (class_2520)componentTag);
        assemblyTag.method_10569("Inserted", 0);
        assemblyTag.method_10569("Total", componentCount);
        return assemblyTag;
    }

    private static boolean insertComponent(class_2487 assemblyTag, class_1799 component) {
        String id;
        class_2487 missingComponents = assemblyTag.method_10562("Missing");
        if (!missingComponents.method_10545(id = class_7923.field_41178.method_10221((Object)component.method_7909()).toString())) {
            return false;
        }
        int missingAmount = missingComponents.method_10550(id);
        if (--missingAmount <= 0) {
            missingComponents.method_10551(id);
        } else {
            missingComponents.method_10569(id, missingAmount);
        }
        assemblyTag.method_10569("Inserted", assemblyTag.method_10550("Inserted") + 1);
        return true;
    }

    @Nullable
    public static class_1799 insert(class_1799 circuit, class_1799 component) {
        class_1799 newStack;
        if (!circuit.method_31574((class_1792)ModdedItems.INCOMPLETE_CIRCUIT.get()) || !circuit.method_7985()) {
            return null;
        }
        class_2487 tag = circuit.method_7969().method_10553();
        if (!tag.method_10545("Assembly")) {
            tag.method_10566("Assembly", (class_2520)IncompleteCircuitItem.makeAssemblyTag(tag.method_10562("Schematic")));
        }
        if (!IncompleteCircuitItem.insertComponent(tag.method_10562("Assembly"), component)) {
            return null;
        }
        class_2487 missing = tag.method_10562("Assembly").method_10562("Missing");
        if (missing.method_33133()) {
            tag.method_10551("Assembly");
            newStack = new class_1799(ModdedBlocks.CIRCUIT_BOARD);
        } else {
            newStack = new class_1799(ModdedItems.INCOMPLETE_CIRCUIT);
        }
        newStack.method_7980(tag);
        return newStack;
    }

    public static float getProgress(class_1799 stack) {
        if (!stack.method_7985() || !stack.method_7969().method_10545("Assembly")) {
            return 0.0f;
        }
        class_2487 assemblyTag = stack.method_7941("Assembly");
        return (float)assemblyTag.method_10550("Inserted") / (float)assemblyTag.method_10550("Total");
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f * IncompleteCircuitItem.getProgress(stack));
    }

    public int method_31571(class_1799 stack) {
        return Color.mixColors((int)-16268, (int)-12124192, (float)IncompleteCircuitItem.getProgress(stack));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_2487 assemblyTag;
        if (!stack.method_7985()) {
            return;
        }
        if (!stack.method_7969().method_10545("Assembly")) {
            if (!stack.method_7969().method_10545("Schematic")) {
                return;
            }
            assemblyTag = IncompleteCircuitItem.makeAssemblyTag(stack.method_7941("Schematic"));
        } else {
            assemblyTag = stack.method_7941("Assembly");
        }
        tooltip.add((class_2561)class_2561.method_43473());
        tooltip.add((class_2561)Lang.translate("tooltip.circuit_assembly", new Object[0]).style(class_124.field_1080).component());
        int inserted = assemblyTag.method_10550("Inserted");
        int total = assemblyTag.method_10550("Total");
        tooltip.add((class_2561)Lang.translate("tooltip.circuit_assembly.progress", new Object[0]).add(class_2561.method_43470((String)String.format(": %d/%d", inserted, total))).style(class_124.field_1063).component());
        class_2487 missing = assemblyTag.method_10562("Missing");
        int index = 0;
        for (String itemId : missing.method_10541()) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemId));
            String key = item.method_7876();
            class_5250 line = switch (index) {
                case 0 -> Lang.translate("tooltip.circuit_assembly.insert", new Object[0]).add(class_2561.method_43470((String)" ")).add(class_2561.method_43471((String)key)).style(class_124.field_1075).component();
                case 1 -> Lang.text("-> ").add(Lang.translate("tooltip.circuit_assembly.insert", new Object[0])).add(class_2561.method_43470((String)" ")).add(class_2561.method_43471((String)key)).style(class_124.field_1062).component();
                default -> throw new IllegalStateException();
            };
            tooltip.add((class_2561)line);
            if (++index < 2) continue;
            break;
        }
    }
}

