/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.electricity.sim.special.CapacitorWire;

public class CapacitorComponent
extends OrientableComponent {
    public static final FloatProperty CAPACITANCE = new FloatProperty("powergrid", "capacitor_value", 0.1f, 1.0E-4f, 1000.0f);
    private static final ChargeProperty CHARGE = new ChargeProperty("powergrid", "charge");

    public CapacitorComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{CAPACITANCE, CHARGE});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        CapacitorWire capacitorWire = new CapacitorWire(placed.get(CAPACITANCE).floatValue() / 1000.0f, builder.terminalNode(0), builder.terminalNode(1));
        capacitorWire.setVoltage(placed.get(CHARGE).floatValue());
        builder.add(capacitorWire);
        placed.add(capacitorWire);
    }

    @Override
    public boolean tick(@NotNull PlacedComponent placed) {
        if (!placed.wires.isEmpty()) {
            placed.set(CHARGE, Float.valueOf(placed.wires.get(0).potentialDifference()));
        }
        return true;
    }

    @Override
    public void stateUpdated(@NotNull PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return;
        }
        CapacitorWire wire = (CapacitorWire)placed.wires.get(0);
        wire.setVoltage(placed.get(CHARGE).floatValue());
    }

    private static class ChargeProperty
    extends FloatProperty {
        public ChargeProperty(String namespace, String name) {
            super(namespace, name, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public Float parse(String str) throws NumberFormatException {
            return Float.valueOf(0.0f);
        }

        @Override
        public boolean isHidden() {
            return true;
        }

        @Override
        protected float limit(float value) {
            return value;
        }
    }
}

