/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.ComponentRegistry;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.ConstantProperty;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.components.properties.StringProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.thermal.ThermalBuilder;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.utility.Unit;

public abstract class Component {
    public static final StringProperty LABEL = new StringProperty("powergrid", "label");
    private static final Map<class_1792, Component> COMPONENT_MAP = new HashMap<class_1792, Component>();
    public static final float BASE_Y = 0.125f;
    private Supplier<? extends class_1792> item;
    private final ComponentFootprint footprint;
    private final ImmutableList<ComponentProperty<?>> properties;

    public Component(ComponentFootprint footprint) {
        this.footprint = footprint;
        ImmutableList.Builder properties = new ImmutableList.Builder();
        this.addProperties((ImmutableCollection.Builder<ComponentProperty<?>>)properties);
        this.properties = properties.build();
    }

    static ConstantProperty c(String name, class_2561 value) {
        return new ConstantProperty("powergrid", name, value);
    }

    public static ConstantProperty power(float value) {
        return new ConstantProperty("powergrid", "power", (class_2561)Unit.POWER.formatWithPrefixes(value).component());
    }

    public static ConstantProperty current(float resistance, float power) {
        return Component.current((float)Math.sqrt(power / resistance));
    }

    public static ConstantProperty current(float value) {
        return new ConstantProperty("powergrid", "current", (class_2561)Unit.CURRENT.formatWithPrefixes(value).component());
    }

    public static ConstantProperty voltage(float value) {
        return new ConstantProperty("powergrid", "voltage", (class_2561)Unit.VOLTAGE.formatWithPrefixes(value).component());
    }

    @Environment(value=EnvType.CLIENT)
    public static void modelChanged(class_2338 pos) {
        class_761 renderer = class_310.method_1551().field_1769;
        renderer.method_18146(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
    }

    public float getPadResistance(int padIndex) {
        return 0.002f;
    }

    public boolean emitExternalTerminals() {
        return false;
    }

    public List<TerminalBoundingBox> terminals(@NotNull PlacedComponent placed) {
        return List.of();
    }

    public abstract void bake(@NotNull PlacedComponent var1, @NotNull ComponentCircuitBuilder var2, @NotNull ThermalBuilder.IEmitter var3);

    public boolean tick(@NotNull PlacedComponent placed) {
        return false;
    }

    public void stateUpdated(@NotNull PlacedComponent placed) {
    }

    void setItem(Supplier<? extends class_1792> item) {
        this.item = item;
    }

    public ComponentFootprint footprint(@Nullable PlacedComponent placed) {
        return this.footprint;
    }

    public class_1792 getRequiredItem() {
        return this.item.get();
    }

    public ImmutableList<ComponentProperty<?>> getProperties() {
        return this.properties;
    }

    public boolean canPlace(@NotNull PlacedComponent placed, int x, int y) {
        return true;
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public class_2960 getModelId(@NotNull PlacedComponent component) {
        return ComponentRegistry.getId(this);
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public Collection<class_2960> requestedModels() {
        return List.of(ComponentRegistry.getId(this));
    }

    public static Component forItem(class_1792 item) {
        if (COMPONENT_MAP.containsKey(item)) {
            return COMPONENT_MAP.get(item);
        }
        for (Component entry : ComponentRegistry.entries()) {
            if (entry.item.get() != item) continue;
            COMPONENT_MAP.put(item, entry);
            return entry;
        }
        COMPONENT_MAP.put(item, null);
        return null;
    }

    @Nullable
    public static Orientation getEdge(@NotNull PlacedComponent placed) {
        if (placed.x == 0) {
            return Orientation.LEFT;
        }
        if (placed.y == 0) {
            return Orientation.UP;
        }
        if (placed.x == 16 - placed.footprint().getWidth()) {
            return Orientation.RIGHT;
        }
        if (placed.y == 16 - placed.footprint().getHeight()) {
            return Orientation.DOWN;
        }
        return null;
    }
}

