/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.GaugeComponent;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.electricity.gauge.CurrentGaugeBlockEntity;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;

public class CurrentGaugeComponent
extends GaugeComponent {
    public static final FloatProperty MAX_CURRENT = new FloatProperty("powergrid", "current_gauge_max", 0.1f, 0.01f, 1.0f);

    public CurrentGaugeComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object)MAX_CURRENT);
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        ElectricWire wire = builder.connect(0.05f, builder.terminalNode(0), builder.terminalNode(1));
        placed.add(wire);
    }

    @Override
    public float getTarget(PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return 0.0f;
        }
        AbstractElectricWire wire = placed.wires.get(0);
        return class_3532.method_15363((float)(Math.abs(wire.current()) / placed.get(MAX_CURRENT).floatValue()), (float)0.0f, (float)1.125f);
    }

    public float getValue(PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return 0.0f;
        }
        AbstractElectricWire wire = placed.wires.get(0);
        return Math.abs(wire.current());
    }

    @Override
    public boolean addToGoggleTooltip(PlacedComponent component, List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(component, tooltip, isPlayerSneaking);
        Float max = component.get(MAX_CURRENT);
        CurrentGaugeBlockEntity.addTooltip(tooltip, this.getValue(component), max.floatValue(), max.floatValue() < 0.5f);
        return true;
    }
}

