/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components;

import com.google.common.collect.ImmutableCollection;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.circuitboard.ComponentCircuitBuilder;
import org.patryk3211.powergrid.circuits.components.IGoggleLabel;
import org.patryk3211.powergrid.circuits.components.IInteractableComponent;
import org.patryk3211.powergrid.circuits.components.IRenderedComponent;
import org.patryk3211.powergrid.circuits.components.OrientableComponent;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.FloatProperty;
import org.patryk3211.powergrid.circuits.components.properties.IntProperty;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedPartialModels;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.network.packets.UpdateComponentBiPacket;
import org.patryk3211.powergrid.utility.CustomValueSettingsScreen;
import org.patryk3211.powergrid.utility.Lang;

public class PotentiometerComponent
extends OrientableComponent
implements IInteractableComponent,
IRenderedComponent,
IGoggleLabel {
    public static final FloatProperty RESISTANCE = new FloatProperty("powergrid", "potentiometer_resistance", 1000.0f, 100.0f, 100000.0f);
    public static final IntProperty VALUE = new IntProperty("powergrid", "potentiometer_value", 50, 0, 100);
    @Environment(value=EnvType.CLIENT)
    private static ValueSettingsBoard BOARD;

    public PotentiometerComponent(ComponentFootprint footprint) {
        super(footprint);
    }

    @Override
    protected void addProperties(ImmutableCollection.Builder<ComponentProperty<?>> properties) {
        super.addProperties(properties);
        properties.add((Object[])new ComponentProperty[]{RESISTANCE, VALUE, LABEL, PotentiometerComponent.power(25.0f)});
    }

    @Override
    public void bake(@NotNull PlacedComponent placed, @NotNull ComponentCircuitBuilder builder,  @NotNull ThermalBuilder.IEmitter thermals) {
        Float R = placed.get(RESISTANCE);
        float V = class_3532.method_37959((float)((float)placed.get(VALUE).intValue() / 100.0f), (float)0.0f, (float)1.0f, (float)0.01f, (float)0.99f);
        ElectricWire wire1 = builder.connect(R.floatValue() * V, builder.terminalNode(0), builder.terminalNode(1));
        ElectricWire wire2 = builder.connect(R.floatValue() * (1.0f - V), builder.terminalNode(1), builder.terminalNode(2));
        placed.add(wire1);
        placed.add(wire2);
        thermals.builder().setMaxPower(25.0f, 125.0f).setThermalMass(0.005f).addHeatSource(wire1).addHeatSource(wire2);
    }

    @Override
    public class_265 getShape(@NotNull PlacedComponent placed) {
        return IInteractableComponent.extrudedFootprint(placed, 0.1875f);
    }

    @Override
    public class_1269 use(CircuitBoardBlockEntity be, PlacedComponent component, class_1657 player) {
        component.onClientWorld(() -> world -> {
            Integer value = component.get(VALUE);
            if (BOARD == null) {
                String label = component.get(LABEL);
                BOARD = CustomValueSettingsScreen.makeBoard((class_2561)(label.isEmpty() ? Lang.translateDirect("gui.potentiometer.setting", new Object[0]) : class_2561.method_43470((String)label)), 100, 10, List.of(class_2561.method_43470((String)"Value")));
            }
            CustomValueSettingsScreen.beginInteraction(() -> new CustomValueSettingsScreen(be.method_11016(), BOARD, new ValueSettingsBehaviour.ValueSettings(0, value.intValue()), setting -> {
                component.set(VALUE, setting.value());
                ModdedPackets.getChannel().sendToServer((Object)new UpdateComponentBiPacket(be, component, VALUE));
            }));
        });
        return class_1269.field_5812;
    }

    @Override
    public void stateUpdated(@NotNull PlacedComponent placed) {
        if (placed.wires.isEmpty()) {
            return;
        }
        Float R = placed.get(RESISTANCE);
        float V = class_3532.method_37959((float)((float)placed.get(VALUE).intValue() / 100.0f), (float)0.0f, (float)1.0f, (float)0.01f, (float)0.99f);
        ElectricWire wire1 = (ElectricWire)placed.wires.get(0);
        ElectricWire wire2 = (ElectricWire)placed.wires.get(1);
        wire1.setResistance(R.floatValue() * V);
        wire2.setResistance(R.floatValue() * (1.0f - V));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(CircuitBoardBlockEntity be, PlacedComponent placed, float partialTicks, class_4587 ms, class_4597 bufferSource, int light, int overlay) {
        SuperByteBuffer buffer = CachedBuffers.partial((PartialModel)ModdedPartialModels.POTENTIOMETER_KNOB, (class_2680)be.method_11010());
        float angle = 135.0f - 270.0f * ((float)placed.get(VALUE).intValue() / 100.0f);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)buffer.translate(0.15625, 0.0, 0.15625)).rotateYDegrees(angle)).translate(-0.15625, 0.0, -0.15625)).light(light).renderInto(ms, bufferSource.getBuffer(class_1921.method_23577()));
    }
}

