/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.fabric;

import io.github.fabricators_of_create.porting_lib.models.QuadTransformers;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.ComponentModels;
import org.patryk3211.powergrid.circuits.components.IRenderedComponent;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.schematic.Area;
import org.patryk3211.powergrid.circuits.schematic.CircuitLayer;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.circuits.schematic.Point;

@Environment(value=EnvType.CLIENT)
public class CircuitBoardModel
implements class_1100,
class_1087 {
    public static final class_1091 MODEL_ID = new class_1091(new class_2960("powergrid", "circuit_board"), "");
    public static final class_2960 BASE_MODEL = PowerGrid.asResource("block/circuit_board");
    private static final class_4730 COPPER_SPRITE_ID = new class_4730(class_1723.field_21668, PowerGrid.asResource("block/circuit_board_trace"));
    private static final class_4730 PAD_SPRITE_ID = new class_4730(class_1723.field_21668, PowerGrid.asResource("block/circuit_board_pad"));
    private class_1058 particleSprite;
    private class_1058 padSprite;
    private class_1058 copperSprite;
    private class_1087 baseModel;

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 face, class_5819 random) {
        return this.baseModel.method_4707(state, face, random);
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return false;
    }

    public boolean method_24304() {
        return false;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particleSprite;
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public Collection<class_2960> method_4755() {
        return List.of(BASE_MODEL);
    }

    public void method_45785(Function<class_2960, class_1100> modelLoader) {
    }

    @Nullable
    public class_1087 method_4753(class_7775 baker, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
        this.copperSprite = textureGetter.apply(COPPER_SPRITE_ID);
        this.padSprite = textureGetter.apply(PAD_SPRITE_ID);
        this.baseModel = baker.method_45873(BASE_MODEL, rotationContainer);
        this.particleSprite = this.baseModel.method_4711();
        return this;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitTrace(Area area, RenderContext context) {
        QuadEmitter emitter = context.getEmitter();
        float x1 = (float)area.x1() / 16.0f;
        float y1 = (float)area.y1() / 16.0f;
        float x2 = (float)area.x2() / 16.0f;
        float y2 = (float)area.y2() / 16.0f;
        emitter.square(class_2350.field_11036, x1 - 0.5f, 1.0f - y2 + 0.5f, x2 - 0.5f, 1.0f - y1 + 0.5f, 1.3725f);
        emitter.uv(0, x1, y1);
        emitter.uv(1, x1, y2);
        emitter.uv(2, x2, y2);
        emitter.uv(3, x2, y1);
        emitter.color(-1, -1, -1, -1);
        emitter.spriteBake(this.copperSprite, 32);
        emitter.emit();
    }

    public void emitPad(Point point, RenderContext context) {
        QuadEmitter emitter = context.getEmitter();
        float x1 = point.x();
        float y1 = point.y();
        float x2 = x1 + 1.0f;
        float y2 = y1 + 1.0f;
        emitter.square(class_2350.field_11036, (x1 /= 16.0f) - 0.5f, 1.0f - (y2 /= 16.0f) + 0.5f, (x2 /= 16.0f) - 0.5f, 1.0f - (y1 /= 16.0f) + 0.5f, 1.3725f);
        emitter.uv(0, x1, y1);
        emitter.uv(1, x1, y2);
        emitter.uv(2, x2, y2);
        emitter.uv(3, x2, y1);
        emitter.color(-1, -1, -1, -1);
        emitter.spriteBake(this.padSprite, 32);
        emitter.emit();
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.pushTransform(QuadTransformers.applying((class_4590)new class_4590(new Vector3f(0.5f, 0.5f, 0.5f), new Quaternionf().rotateY((float)Math.PI * (float)CircuitBoardBlock.getAngleY(state) / 180.0f).rotateX((float)Math.PI * (float)CircuitBoardBlock.getAngleX(state) / 180.0f), null, null)));
        this.baseModel.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        class_2586 be = blockView.method_8321(pos);
        if (be instanceof CircuitBoardBlockEntity) {
            CircuitBoardBlockEntity circuit = (CircuitBoardBlockEntity)be;
            CircuitSchematic schematic = circuit.getSchematic();
            for (PlacedComponent placedComponent : schematic.components()) {
                int color;
                IRenderedComponent rendered;
                if (placedComponent instanceof IRenderedComponent && !(rendered = (IRenderedComponent)((Object)placedComponent)).emitBaked()) continue;
                class_1087 model = ComponentModels.getModel(placedComponent);
                int n = color = placedComponent.destroyed ? -12566464 : -1;
                if (placedComponent.has(Orientation.PROPERTY)) {
                    Orientation orientation = placedComponent.get(Orientation.PROPERTY);
                    ComponentFootprint footprint = placedComponent.component.footprint(null);
                    context.pushTransform((RenderContext.QuadTransform)new RotateOffsetTransform(placedComponent.x, 2, placedComponent.y, orientation, footprint.getWidth(), footprint.getHeight(), color));
                } else {
                    context.pushTransform((RenderContext.QuadTransform)new OffsetTransform(placedComponent.x, 2, placedComponent.y, color));
                }
                model.emitBlockQuads(blockView, state, pos, randomSupplier, context);
                context.popTransform();
            }
            List<Area> areas = circuit.getSchematic().calculateAreas(CircuitSchematic.Layer.FRONT);
            for (Area area : areas) {
                this.emitTrace(area, context);
            }
            CircuitLayer circuitLayer = circuit.getSchematic().pads();
            List<Point> points = circuitLayer.calculatePoints();
            for (Point point : points) {
                this.emitPad(point, context);
            }
        }
        context.popTransform();
    }

    private static class RotateOffsetTransform
    extends OffsetTransform {
        protected final Orientation orientation;
        protected final float width;
        protected final float height;

        public RotateOffsetTransform(int x, int y, int z, Orientation orientation, int width, int height, int color) {
            super(x, y, z, color);
            this.orientation = orientation;
            this.width = (float)width / 16.0f;
            this.height = (float)height / 16.0f;
        }

        @Override
        public boolean transform(MutableQuadView view) {
            for (int i = 0; i < 4; ++i) {
                float x = view.x(i);
                float y = view.y(i);
                float z = view.z(i);
                switch (this.orientation) {
                    case DOWN: {
                        float buf = x;
                        x = this.height - z;
                        z = buf;
                        break;
                    }
                    case LEFT: {
                        x = this.width - x;
                        z = this.height - z;
                        break;
                    }
                    case UP: {
                        float buf = z;
                        z = this.width - x;
                        x = buf;
                    }
                }
                view.pos(i, x + this.x, y + this.y, z + this.z);
            }
            return true;
        }
    }

    private static class OffsetTransform
    implements RenderContext.QuadTransform {
        protected final float x;
        protected final float y;
        protected final float z;
        protected final int color;

        public OffsetTransform(int x, int y, int z, int color) {
            this.x = (float)x / 16.0f - 0.5f;
            this.y = (float)y / 16.0f - 0.5f;
            this.z = (float)z / 16.0f - 0.5f;
            this.color = color;
        }

        public boolean transform(MutableQuadView view) {
            for (int i = 0; i < 4; ++i) {
                float x = view.x(i);
                float y = view.y(i);
                float z = view.z(i);
                view.pos(i, x + this.x, y + this.y, z + this.z);
                view.color(i, this.color);
            }
            return true;
        }
    }
}

