/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.components.properties;

import org.patryk3211.powergrid.circuits.components.properties.EnumProperty;

public enum Orientation {
    RIGHT(2, 3, 1),
    UP(3, 0, 2),
    LEFT(0, 1, 3),
    DOWN(1, 2, 0);

    public static final EnumProperty<Orientation> PROPERTY;
    private final int idOpposite;
    private final int idClockwise;
    private final int idCounterClockwise;

    private Orientation(int idOpposite, int idClockwise, int idCounterClockwise) {
        this.idOpposite = idOpposite;
        this.idClockwise = idClockwise;
        this.idCounterClockwise = idCounterClockwise;
    }

    public Orientation getOpposite() {
        return Orientation.values()[this.idOpposite];
    }

    public Orientation getClockwise() {
        return Orientation.values()[this.idClockwise];
    }

    public Orientation getCounterClockwise() {
        return Orientation.values()[this.idCounterClockwise];
    }

    public Orientation rotate(Orientation rotateBy) {
        switch (rotateBy.ordinal()) {
            case 0: {
                return this;
            }
            case 3: {
                return this.getClockwise();
            }
            case 2: {
                return this.getOpposite();
            }
            case 1: {
                return this.getCounterClockwise();
            }
        }
        throw new IllegalStateException();
    }

    public boolean positive() {
        return this == RIGHT || this == DOWN;
    }

    static {
        PROPERTY = (EnumProperty)new EnumProperty<Orientation>("powergrid", "orientation", Orientation.class).hidden();
    }
}

