/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.editor;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableBlockEntity;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableLoadMenu;
import org.patryk3211.powergrid.circuits.gui.CircuitFileBox;
import org.patryk3211.powergrid.circuits.schematic.CircuitSchematic;
import org.patryk3211.powergrid.collections.ModIcons;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.network.packets.ChangeScreenC2SPacket;
import org.patryk3211.powergrid.network.packets.SaveSchematicC2SPacket;
import org.patryk3211.powergrid.utility.Lang;

public class CircuitDesignTableLoadScreen
extends AbstractSimiContainerScreen<CircuitDesignTableLoadMenu> {
    private static final class_2960 BACKGROUND = PowerGrid.texture("gui/circuit_design_table_load");
    private static final int WIDTH = 214;
    private static final int HEIGHT = 85;
    private static final class_2561 NO_NAME = Lang.translateDirect("gui.circuit_designer.no_name", new Object[0]);
    private static final class_2561 CONFIRM_OVERWRITE = Lang.translateDirect("gui.circuit_designer.confirm_overwrite", new Object[0]);
    private static final class_2561 DOESNT_EXIST = Lang.translateDirect("gui.circuit_designer.doesnt_exist", new Object[0]);
    private static final class_2561 INVALID_FILE = Lang.translateDirect("gui.circuit_designer.invalid_file", new Object[0]);
    private static final class_2561 FILE_DIALOG = Lang.translateDirect("gui.circuit_designer.file_dialog", new Object[0]);
    private static final class_2561 CANCEL = Lang.translateDirect("gui.circuit_designer.cancel", new Object[0]);
    private static final class_2561 FILE_SAVE = Lang.translateDirect("gui.circuit_designer.file_save", new Object[0]);
    private static final class_2561 FILE_LOAD = Lang.translateDirect("gui.circuit_designer.file_load", new Object[0]);
    private IconButton cancelBtn;
    private IconButton saveBtn;
    private IconButton loadBtn;
    private IconButton folderBtn;
    private CircuitFileBox fileNameInput;
    private class_2561 popupText;
    private int popupTimeout;
    private boolean confirm;

    public CircuitDesignTableLoadScreen(CircuitDesignTableLoadMenu container, class_1661 inv, class_2561 title) {
        super((class_1703)container, inv, title);
    }

    private static class_1144 soundManager() {
        return class_310.method_1551().method_1483();
    }

    private static void playSound(AllSoundEvents.SoundEntry sound) {
        CircuitDesignTableLoadScreen.soundManager().method_4873((class_1113)class_1109.method_4758((class_3414)sound.getMainEvent(), (float)1.0f));
    }

    private void save() {
        if (this.fileNameInput.method_1882().isEmpty()) {
            this.popup(NO_NAME);
            return;
        }
        try {
            Path file = Path.of("circuits", this.fileNameInput.method_1882());
            if (!file.toString().endsWith(".nbt")) {
                file = Path.of(String.valueOf(file) + ".nbt", new String[0]);
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            if (Files.exists(file, new LinkOption[0]) && !this.confirm) {
                this.confirm = true;
                this.popup(CONFIRM_OVERWRITE);
                return;
            }
            Files.deleteIfExists(file);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE);){
                class_2507.method_10634((class_2487)((CircuitDesignTableBlockEntity)((CircuitDesignTableLoadMenu)this.field_2797).contentHolder).schematic.serializeNbt(), (OutputStream)out);
            }
            this.back();
        }
        catch (IOException e) {
            PowerGrid.LOGGER.error("Failed to save circuit schematic", (Throwable)e);
        }
        this.confirm = false;
    }

    private void load() {
        Path file = Path.of("circuits", this.fileNameInput.method_1882());
        if (!file.toString().endsWith(".nbt")) {
            file = Path.of(String.valueOf(file) + ".nbt", new String[0]);
        }
        if (!Files.exists(file, new LinkOption[0])) {
            this.popup(DOESNT_EXIST);
            return;
        }
        try (InputStream in = Files.newInputStream(file, StandardOpenOption.READ);){
            class_2487 nbt = class_2507.method_10629((InputStream)in);
            CircuitSchematic schematic = CircuitSchematic.fromNbt(nbt);
            ModdedPackets.getChannel().sendToServer((Object)new SaveSchematicC2SPacket((CircuitDesignTableBlockEntity)((CircuitDesignTableLoadMenu)this.field_2797).contentHolder, null, schematic));
        }
        catch (IOException e) {
            PowerGrid.LOGGER.error("Failed to load circuit schematic", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.popup(INVALID_FILE);
        }
    }

    private void back() {
        ModdedPackets.getChannel().sendToServer((Object)new ChangeScreenC2SPacket((CircuitDesignTableBlockEntity)((CircuitDesignTableLoadMenu)this.field_2797).contentHolder, 0));
    }

    protected void method_25426() {
        this.setWindowSize(214, 85);
        super.method_25426();
        this.fileNameInput = new CircuitFileBox(this.field_22793, this.field_2776 + 48, this.field_2800 + 28, 135, 10, (class_2561)class_2561.method_43473());
        this.cancelBtn = new IconButton(this.field_2776 + 20, this.field_2800 + 58, (ScreenElement)ModIcons.I_CANCEL);
        this.cancelBtn.withCallback(this::back);
        this.cancelBtn.setToolTip(CANCEL);
        this.saveBtn = new IconButton(this.field_2776 + 146, this.field_2800 + 58, (ScreenElement)AllIcons.I_CONFIG_SAVE);
        this.saveBtn.withCallback(this::save);
        this.saveBtn.setToolTip(FILE_SAVE);
        this.loadBtn = new IconButton(this.field_2776 + 168, this.field_2800 + 58, (ScreenElement)ModIcons.I_UPLOAD);
        this.loadBtn.withCallback(this::load);
        this.loadBtn.setToolTip(FILE_LOAD);
        this.folderBtn = new IconButton(this.field_2776 + 20, this.field_2800 + 23, (ScreenElement)AllIcons.I_OPEN_FOLDER);
        this.folderBtn.withCallback(() -> class_156.method_668().method_672(Paths.get("circuits/", new String[0]).toFile()));
        this.method_37063((class_364)this.cancelBtn);
        this.method_37063((class_364)this.saveBtn);
        this.method_37063((class_364)this.loadBtn);
        this.method_37063((class_364)this.folderBtn);
        this.method_37063((class_364)this.fileNameInput);
    }

    protected void method_37432() {
        super.method_37432();
        this.fileNameInput.method_1865();
        if (this.popupTimeout > 0) {
            --this.popupTimeout;
        }
    }

    private void popup(class_2561 text) {
        CircuitDesignTableLoadScreen.playSound(ModdedSoundEvents.UI_FAIL);
        this.popupText = text;
        this.popupTimeout = 60;
    }

    protected void method_2389(class_332 ctx, float partialTick, int mouseX, int mouseY) {
        int bgX = this.getLeftOfCentered(214);
        ctx.method_25302(BACKGROUND, bgX, this.field_2800, 0, 0, 214, 85);
        ctx.method_51439(this.field_22793, FILE_DIALOG, this.field_2776 + 5, this.field_2800 + 4, 0x404040, false);
        if (this.popupTimeout > 0) {
            int color = 0xFF6060;
            int alpha = Math.min(this.popupTimeout, 20) * 255 / 20;
            ctx.method_27534(this.field_22793, this.popupText, this.field_22789 / 2, this.field_2800 - 12, color |= alpha << 24);
        }
    }

    protected void renderForeground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        if (this.fileNameInput != null && this.fileNameInput.method_25405(mouseX, mouseY)) {
            List<class_2561> tooltip = this.fileNameInput.getToolTip();
            if (tooltip.isEmpty()) {
                return;
            }
            graphics.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
    }
}

