/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.schematic;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.circuits.components.properties.Orientation;
import org.patryk3211.powergrid.circuits.schematic.Point;

public class ComponentFootprint {
    private static final class_2960 ARROWS = PowerGrid.texture("gui/circuit_arrows");
    private static final PadData NONE = new PadData(-1, null, null);
    private final int width;
    private final int height;
    private final SortedMap<Point, PadData> pads;
    private final boolean outline;
    @Nullable
    private final Supplier<class_1792> renderedItem;
    @Nullable
    private final Orientation arrow;
    private class_1799 renderedStack;

    protected ComponentFootprint(int width, int height, SortedMap<Point, PadData> pads, boolean outline, @Nullable Supplier<class_1792> renderedItem, @Nullable Orientation arrow) {
        this.width = width;
        this.height = height;
        this.pads = pads;
        this.outline = outline;
        this.renderedItem = renderedItem;
        this.arrow = arrow;
    }

    @Environment(value=EnvType.CLIENT)
    protected void renderPads(@NotNull class_332 ctx, int x, int y) {
        class_4587 ms = ctx.method_51448();
        ms.method_22903();
        ms.method_22905(0.25f, 0.25f, 0.25f);
        for (Point point : this.pads.keySet()) {
            int x1 = (point.x() + x) * 4;
            int y1 = (point.y() + y) * 4;
            ctx.method_25294(x1 + 1, y1 + 1, x1 + 3, y1 + 3, -215549);
        }
        ms.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public void render(@NotNull class_332 ctx, int x, int y, boolean hovering) {
        class_4587 ms = ctx.method_51448();
        if (this.outline) {
            ms.method_22903();
            ms.method_22905(0.5f, 0.5f, 0.5f);
            ctx.method_49601(x * 2, y * 2, this.width * 1 * 2, this.height * 1 * 2, -2131724050);
            ms.method_22909();
        }
        this.renderPads(ctx, x, y);
        if (this.renderedItem != null && !hovering) {
            ms.method_22903();
            int maxSize = 2;
            float scale = (float)Math.min(Math.min(this.width, this.height), 2) / 16.0f * 1.0f;
            if (this.width > 2 && this.height > 2) {
                ms.method_46416((float)(this.width - 2) * 0.5f, (float)(this.height - 2) * 0.5f, 0.0f);
            } else if (this.width > this.height) {
                float offset = (float)(this.width - this.height) * 0.5f;
                ms.method_46416(offset, 0.0f, 0.0f);
            } else if (this.height > this.width) {
                float offset = (float)(this.height - this.width) * 0.5f;
                ms.method_46416(0.0f, offset, 0.0f);
            }
            ms.method_22905(scale, scale, scale);
            ctx.method_51427(this.getRenderedStack(), (int)((float)x / scale), (int)((float)y / scale));
            ms.method_22909();
        }
        if (this.arrow != null) {
            ms.method_22903();
            int u = this.arrow.ordinal() % 2 * 8;
            int v = this.arrow.ordinal() / 2 * 8;
            ms.method_46416((float)x + (float)(this.width * 1) * 0.5f, (float)y + (float)(this.height * 1) * 0.5f, 0.0f);
            switch (this.arrow) {
                case RIGHT: {
                    ms.method_46416((float)(this.width / 2), 0.0f, 0.0f);
                    break;
                }
                case LEFT: {
                    ms.method_46416((float)(-this.width / 2), 0.0f, 0.0f);
                    break;
                }
                case DOWN: {
                    ms.method_46416(0.0f, (float)(this.height / 2), 0.0f);
                    break;
                }
                case UP: {
                    ms.method_46416(0.0f, (float)(-this.height / 2), 0.0f);
                }
            }
            ms.method_22905(0.25f, 0.25f, 1.0f);
            ms.method_46416(-4.0f, -4.0f, 0.0f);
            ctx.method_25290(ARROWS, 0, 0, (float)u, (float)v, 8, 8, 16, 16);
            ms.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void renderPadIndices(@NotNull class_332 ctx, @NotNull class_327 textRenderer, int x, int y) {
        class_4587 ms = ctx.method_51448();
        ms.method_22903();
        int scale = 12;
        ms.method_46416(0.5f, 0.5f, 100.0f);
        ms.method_22905(1.0f / (float)scale, 1.0f / (float)scale, 1.0f);
        for (Map.Entry<Point, PadData> entry : this.pads.entrySet()) {
            Point point = entry.getKey();
            int x1 = (point.x() + x) * scale;
            int y1 = (point.y() + y) * scale;
            class_2561 text = entry.getValue().shortText();
            if (text == null) continue;
            int width = textRenderer.method_27525((class_5348)text);
            ctx.method_51439(textRenderer, text, x1 - width / 2, y1 - 4, -1, false);
        }
        ms.method_22909();
    }

    @Nullable
    public class_2561 getTooltip(int mouseX, int mouseY) {
        PadData pad = (PadData)this.pads.get(new Point(mouseX, mouseY));
        if (pad == null) {
            return null;
        }
        return pad.tooltip;
    }

    @Nullable
    public class_1799 getRenderedStack() {
        if (this.renderedItem == null) {
            return null;
        }
        if (this.renderedStack == null) {
            this.renderedStack = this.renderedItem.get().method_7854();
        }
        return this.renderedStack;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Map<Point, PadData> getPads() {
        return this.pads;
    }

    public ComponentFootprint rotated(Orientation orientation) {
        int height;
        int width;
        if (orientation == Orientation.UP || orientation == Orientation.DOWN) {
            width = this.height;
            height = this.width;
        } else {
            width = this.width;
            height = this.height;
        }
        TreeMap<Point, PadData> pads = new TreeMap<Point, PadData>();
        for (Map.Entry<Point, PadData> pad : this.pads.entrySet()) {
            int x;
            Point position = pad.getKey();
            pads.put(new Point(x, switch (orientation) {
                case Orientation.RIGHT -> {
                    x = position.x();
                    yield position.y();
                }
                case Orientation.DOWN -> {
                    x = this.height - position.y() - 1;
                    yield position.x();
                }
                case Orientation.LEFT -> {
                    x = this.width - position.x() - 1;
                    yield this.height - position.y() - 1;
                }
                case Orientation.UP -> {
                    x = position.y();
                    yield this.width - position.x() - 1;
                }
                default -> throw new IllegalStateException("Invalid orientation: " + String.valueOf((Object)orientation));
            }), pad.getValue());
        }
        ComponentFootprint footprint = new ComponentFootprint(width, height, pads, this.outline, this.renderedItem, this.arrow == null ? null : this.arrow.rotate(orientation));
        footprint.renderedStack = this.renderedStack;
        return footprint;
    }

    public record PadData(int nodeIndex, @Nullable class_2561 tooltip, @Nullable class_2561 shortText) {
    }

    public static class Builder {
        private final int width;
        private final int height;
        private final SortedMap<Point, PadData> pads = new TreeMap<Point, PadData>();
        private Supplier<class_1792> itemSupplier;
        private boolean outline = false;
        private Orientation arrow = null;
        @Nullable
        private final String translationKey;
        public final Map<String, String> translatedPads = new HashMap<String, String>();

        public Builder(int width, int height) {
            this(width, height, null);
        }

        public Builder(int width, int height, String translationKeyBase) {
            this.width = width;
            this.height = height;
            this.translationKey = translationKeyBase;
        }

        private void validatePad(int x, int y) {
            if (x < 0 || y < 0 || x >= this.width * 1 || y >= this.height * 1) {
                throw new IllegalArgumentException("Pad position must be inside defined footprint size");
            }
        }

        public Builder addPad(int x, int y) {
            this.validatePad(x, y);
            this.pads.put(new Point(x, y), NONE);
            return this;
        }

        public Builder addPad(int x, int y, int nodeIndex) {
            return this.addPad(x, y, nodeIndex, (class_2561)null, null);
        }

        public Builder addPad(int x, int y, int nodeIndex, @Nullable class_2561 tooltip, @Nullable class_2561 shortText) {
            this.validatePad(x, y);
            this.pads.put(new Point(x, y), new PadData(nodeIndex, tooltip, shortText));
            return this;
        }

        public Builder addPad(int x, int y, int nodeIndex, String defaultLang, String defaultShort) {
            if (this.translationKey == null) {
                throw new IllegalCallerException("This method may only be used when the translation key base is set");
            }
            String key = this.translationKey + "." + nodeIndex;
            this.translatedPads.put(key, defaultLang);
            if (defaultShort != null) {
                this.translatedPads.put(key + ".short", defaultShort);
            }
            return this.addPad(x, y, nodeIndex, (class_2561)class_2561.method_43471((String)key), (class_2561)(defaultShort == null ? null : class_2561.method_43471((String)(key + ".short"))));
        }

        public Builder withOutline() {
            this.outline = true;
            return this;
        }

        public Builder withItem(Supplier<class_1792> itemSupplier) {
            this.itemSupplier = itemSupplier;
            return this;
        }

        public Builder withArrow(Orientation facing) {
            this.arrow = facing;
            return this;
        }

        public Builder withArrow() {
            this.arrow = Orientation.RIGHT;
            return this;
        }

        public ComponentFootprint build() {
            TreeSet<Integer> padIndices = new TreeSet<Integer>();
            for (PadData pad : this.pads.values()) {
                if (pad.nodeIndex < 0) continue;
                padIndices.add(pad.nodeIndex);
            }
            if (!padIndices.isEmpty()) {
                if ((Integer)padIndices.first() != 0) {
                    throw new IllegalStateException("Footprint pad indices must start from 0");
                }
                if ((Integer)padIndices.last() != padIndices.size() - 1) {
                    throw new IllegalStateException("Footprint pad indices must not contain any gaps");
                }
            }
            return new ComponentFootprint(this.width, this.height, this.pads, this.outline, this.itemSupplier, this.arrow);
        }
    }
}

