/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.circuits.schematic;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.Component;
import org.patryk3211.powergrid.circuits.components.ComponentRegistry;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.PropertyEntry;
import org.patryk3211.powergrid.circuits.schematic.ComponentFootprint;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.network.packets.UpdateComponentBiPacket;

public class PlacedComponent {
    public final Component component;
    public final int x;
    public final int y;
    public final UUID uuid;
    private final List<PropertyEntry<?>> properties = new ArrayList();
    private Supplier<class_1937> worldSupplier;
    private class_2338 pos;
    public final List<INode> nodes = new ArrayList<INode>();
    public final List<AbstractElectricWire> wires = new ArrayList<AbstractElectricWire>();
    public Object customData;
    public boolean destroyed;

    public PlacedComponent(class_2487 tag) {
        this(PlacedComponent.get(tag.method_10558("Id")), tag.method_10550("X"), tag.method_10550("Y"), tag.method_25926("UUID"));
        class_2487 propertyMap = tag.method_10562("Properties");
        for (PropertyEntry<?> entry : this.properties) {
            entry.read(propertyMap);
        }
    }

    public PlacedComponent(PlacedComponent placed) {
        this(placed.component, placed.x, placed.y, placed.uuid);
        this.worldSupplier = placed.worldSupplier;
        this.pos = placed.pos;
        this.destroyed = placed.destroyed;
        this.customData = placed.customData;
        for (PropertyEntry<?> property : this.properties) {
            property.setValueRaw(placed.get(property.property));
        }
    }

    public PlacedComponent(PlacedComponent placed, int x, int y) {
        this(placed.component, x, y, UUID.randomUUID());
        this.worldSupplier = placed.worldSupplier;
        for (PropertyEntry<?> property : this.properties) {
            property.setValueRaw(placed.get(property.property));
        }
    }

    private static Component get(String id) {
        return ComponentRegistry.get(new class_2960(id));
    }

    public PlacedComponent(Component component, int x, int y, UUID uuid) {
        this.component = component;
        this.x = x;
        this.y = y;
        this.uuid = uuid;
        for (ComponentProperty property : component.getProperties()) {
            this.properties.add(PropertyEntry.makeFor(property, this));
        }
    }

    public void withWorld(Supplier<class_1937> worldSupplier, class_2338 pos) {
        this.worldSupplier = worldSupplier;
        this.pos = pos;
    }

    public class_1937 getWorld() {
        return this.worldSupplier.get();
    }

    public void onClientWorld(Supplier<Consumer<class_1937>> callback) {
        class_1937 world = this.getWorld();
        if (world.field_9236) {
            callback.get().accept(world);
        }
    }

    public void onServerWorld(Supplier<Consumer<class_1937>> callback) {
        class_1937 world = this.getWorld();
        if (!world.field_9236) {
            callback.get().accept(world);
        }
    }

    public class_2487 serializeNbt() {
        class_2487 tag = new class_2487();
        class_2960 id = ComponentRegistry.getId(this.component);
        tag.method_10582("Id", id.toString());
        tag.method_10569("X", this.x);
        tag.method_10569("Y", this.y);
        tag.method_25927("UUID", this.uuid);
        if (!this.properties.isEmpty()) {
            class_2487 propertyMap = new class_2487();
            for (PropertyEntry<?> entry : this.properties) {
                entry.write(propertyMap);
            }
            tag.method_10566("Properties", (class_2520)propertyMap);
        }
        return tag;
    }

    public ComponentFootprint footprint() {
        return this.component.footprint(this);
    }

    public boolean canPlace(int x, int y) {
        return this.component.canPlace(this, x, y);
    }

    public boolean tick() {
        return this.component.tick(this);
    }

    public void stateUpdated() {
        this.component.stateUpdated(this);
    }

    public void notifyClients(ComponentProperty<?> property) {
        this.onServerWorld(() -> world -> {
            CircuitBoardBlockEntity circuit = (CircuitBoardBlockEntity)world.method_8321(this.pos);
            if (circuit == null) {
                return;
            }
            ModdedPackets.sendToClientsTracking(new UpdateComponentBiPacket(circuit, this, property), (class_2586)circuit);
        });
    }

    public void notifyClients(class_2960 propertyId) {
        this.onServerWorld(() -> world -> {
            CircuitBoardBlockEntity circuit = (CircuitBoardBlockEntity)world.method_8321(this.pos);
            if (circuit == null) {
                return;
            }
            ModdedPackets.sendToClientsTracking(new UpdateComponentBiPacket(circuit, this, propertyId), (class_2586)circuit);
        });
    }

    public <T> T get(ComponentProperty<T> property) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            return (T)entry.get();
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public boolean has(ComponentProperty<?> property) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            return true;
        }
        return false;
    }

    public PropertyEntry<?> getEntry(class_2960 id) {
        for (PropertyEntry<?> entry : this.properties) {
            if (!entry.property.id().equals((Object)id)) continue;
            return entry;
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public <T> PropertyEntry<T> getEntry(ComponentProperty<T> property) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            return entry;
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public <T> void set(ComponentProperty<T> property, T value) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            entry.setValueRaw(value);
            return;
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public String getString(ComponentProperty<?> property) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            return entry.stringValue();
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public void setString(ComponentProperty<?> property, String value) {
        for (PropertyEntry<?> entry : this.properties) {
            if (entry.property != property) continue;
            entry.setValue(value);
            return;
        }
        throw new IllegalArgumentException("Placed components doesn't have the requested property");
    }

    public boolean intersects(int x, int y, int width, int height) {
        ComponentFootprint footprint = this.footprint();
        return this.x < x + width && this.x + footprint.getWidth() > x && this.y < y + height && this.y + footprint.getHeight() > y;
    }

    public boolean intersects32(int x, int y, int width, int height) {
        ComponentFootprint footprint = this.footprint();
        return this.x * 1 < x + width && this.x * 1 + footprint.getWidth() * 1 > x && this.y * 1 < y + height && this.y * 1 + footprint.getHeight() * 1 > y;
    }

    public void add(INode node) {
        this.nodes.add(node);
    }

    public void add(AbstractElectricWire wire) {
        this.wires.add(wire);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public class_2338 getPos() {
        return this.pos;
    }
}

