/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.patryk3211.powergrid.electricity.sim.PerformanceCounter;
import org.patryk3211.powergrid.utility.NumberFormats;

public class PerformanceCommand {
    public static PerformanceCounterArgument argument() {
        return PerformanceCounterArgument.INSTANCE;
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"performance").then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"counter_name", (ArgumentType)PerformanceCommand.argument()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            PerformanceCounter counter = (PerformanceCounter)ctx.getArgument("counter_name", PerformanceCounter.class);
            source.method_45068((class_2561)class_2561.method_43470((String)("Performance counter '" + counter.getName() + "':")).method_27692(class_124.field_1080));
            source.method_45068((class_2561)class_2561.method_43470((String)"  Last measurement: ").method_10852((class_2561)class_2561.method_43470((String)counter.getTimestamp()).method_27692(class_124.field_1075)).method_27692(class_124.field_1080));
            source.method_45068((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43470((String)"Min").method_27692(class_124.field_1080)).method_27693(" / ").method_10852((class_2561)class_2561.method_43470((String)"Max").method_27692(class_124.field_1080)).method_27693(" / ").method_10852((class_2561)class_2561.method_43470((String)"Avg").method_27692(class_124.field_1080)).method_27692(class_124.field_1063));
            source.method_45068((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43470((String)(NumberFormats.formatConstant(counter.getMin()) + "\u00b5s")).method_27692(class_124.field_1075)).method_27693(" / ").method_10852((class_2561)class_2561.method_43470((String)(NumberFormats.formatConstant(counter.getMax()) + "\u00b5s")).method_27692(class_124.field_1075)).method_27693(" / ").method_10852((class_2561)class_2561.method_43470((String)(NumberFormats.formatConstant(counter.getAvg()) + "\u00b5s")).method_27692(class_124.field_1075)).method_27692(class_124.field_1063));
            return 1;
        })))).then(class_2170.method_9247((String)"period").then(class_2170.method_9244((String)"counter_name", (ArgumentType)PerformanceCommand.argument()).then(class_2170.method_9244((String)"ms_period", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            PerformanceCounter counter = (PerformanceCounter)ctx.getArgument("counter_name", PerformanceCounter.class);
            Integer period = (Integer)ctx.getArgument("ms_period", Integer.class);
            source.method_45068((class_2561)class_2561.method_43470((String)("Performance counter '" + counter.getName() + "' measurement period set to " + period + "ms")).method_27692(class_124.field_1080));
            counter.setMeasurementTime(period);
            return 1;
        }))));
    }

    public static class PerformanceCounterArgument
    implements ArgumentType<PerformanceCounter> {
        public static final PerformanceCounterArgument INSTANCE = new PerformanceCounterArgument();

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return CompletableFuture.supplyAsync(() -> {
                for (PerformanceCounter counter : PerformanceCounter.COUNTERS) {
                    builder.suggest(counter.getName());
                }
                return builder.build();
            });
        }

        public PerformanceCounter parse(StringReader reader) throws CommandSyntaxException {
            int start = reader.getCursor();
            while (reader.canRead() && (StringReader.isAllowedInUnquotedString((char)reader.peek()) || reader.peek() == ':')) {
                reader.skip();
            }
            String name = reader.getString().substring(start, reader.getCursor());
            PerformanceCounter prev = null;
            boolean cleanup = false;
            for (PerformanceCounter counter : PerformanceCounter.COUNTERS) {
                if (!name.equals(counter.getName())) continue;
                if (prev != null) {
                    cleanup = true;
                }
                prev = counter;
            }
            if (cleanup) {
                Iterator<PerformanceCounter> iter = PerformanceCounter.COUNTERS.iterator();
                while (iter.hasNext()) {
                    PerformanceCounter counter;
                    counter = iter.next();
                    if (!name.equals(counter.getName()) || counter == prev) continue;
                    iter.remove();
                }
            }
            if (prev != null) {
                return prev;
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Performance counter '" + name + "' doesn't exist!")).method_27692(class_124.field_1061)).create();
        }
    }
}

