/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.config;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.ThermalValues;

public class CThermal
extends ConfigBase
implements ThermalValues.Provider {
    private static final int VERSION = 1;
    private static final Object2DoubleMap<class_2960> DEFAULT_THERMAL_MASS = new Object2DoubleOpenHashMap();
    private static final Object2DoubleMap<class_2960> DEFAULT_POWERS = new Object2DoubleOpenHashMap();
    protected final Map<class_2960, ForgeConfigSpec.ConfigValue<Double>> thermalMasses = new HashMap<class_2960, ForgeConfigSpec.ConfigValue<Double>>();
    protected final Map<class_2960, ForgeConfigSpec.ConfigValue<Double>> power = new HashMap<class_2960, ForgeConfigSpec.ConfigValue<Double>>();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{".", Comments.thermalMass}).push("mass");
        DEFAULT_THERMAL_MASS.forEach((id, value) -> this.thermalMasses.put((class_2960)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.method_12832(), value)));
        builder.pop();
        builder.comment(new String[]{".", Comments.watt, Comments.power}).push("power");
        DEFAULT_POWERS.forEach((id, value) -> this.power.put((class_2960)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.method_12832(), value)));
        builder.pop();
    }

    public String getName() {
        return "thermal-v1";
    }

    @Override
    @Nullable
    public DoubleSupplier getMass(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        ForgeConfigSpec.ConfigValue<Double> entry = this.thermalMasses.get(id);
        return entry == null ? null : () -> entry.get();
    }

    @Override
    @Nullable
    public DoubleSupplier getPower(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        ForgeConfigSpec.ConfigValue<Double> entry = this.power.get(id);
        return entry == null ? null : () -> entry.get();
    }

    public static <B extends class_2248, P> NonNullUnaryOperator<BlockBuilder<B, P>> maxPower(double power, double thermalMass) {
        return builder -> {
            CThermal.assertFromPowerGrid(builder);
            class_2960 id = PowerGrid.asResource(builder.getName());
            DEFAULT_THERMAL_MASS.put((Object)id, thermalMass);
            DEFAULT_POWERS.put((Object)id, power);
            return builder;
        };
    }

    private static void assertFromPowerGrid(BlockBuilder<?, ?> builder) {
        if (!builder.getOwner().getModid().equals("powergrid")) {
            throw new IllegalStateException("Non-Power Grid blocks cannot be added to Power Grid's config.");
        }
    }

    private static class Comments {
        static String watt = "[in Watts]";
        static String thermalMass = "Configures the amount of energy needed to raise the temperature of the device (this allows for higher temporary loads)";
        static String power = "Configures the maximum power dissipated by the device";

        private Comments() {
        }
    }
}

