/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.config;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.WireValues;
import org.patryk3211.powergrid.electricity.wire.WireItem;

public class CWire
extends ConfigBase
implements WireValues.Provider {
    private static final int VERSION = 1;
    private static final Object2DoubleMap<class_2960> DEFAULT_VALUES = new Object2DoubleOpenHashMap();
    protected final Map<class_2960, ForgeConfigSpec.ConfigValue<Double>> values = new HashMap<class_2960, ForgeConfigSpec.ConfigValue<Double>>();

    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(".").push("wire");
        DEFAULT_VALUES.forEach((id, value) -> this.values.put((class_2960)id, (ForgeConfigSpec.ConfigValue<Double>)builder.define(id.method_12832(), value)));
        builder.pop();
    }

    public String getName() {
        return "wires-v1";
    }

    @Nullable
    public DoubleSupplier get(WireItem item, String suffix) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item).method_48331("." + suffix);
        ForgeConfigSpec.ConfigValue<Double> entry = this.values.get(id);
        return entry == null ? null : () -> entry.get();
    }

    @Override
    @Nullable
    public DoubleSupplier resistance(WireItem wire) {
        return this.get(wire, "resistance");
    }

    @Override
    @Nullable
    public DoubleSupplier maxLength(WireItem wire) {
        return this.get(wire, "max-length");
    }

    @Override
    @Nullable
    public DoubleSupplier thermalMass(WireItem wire) {
        return this.get(wire, "thermal-mass");
    }

    @Override
    @Nullable
    public DoubleSupplier dissipationFactor(WireItem wire) {
        DoubleSupplier pR = this.get(wire, "resistance");
        DoubleSupplier pI = this.get(wire, "max-current");
        if (pR == null || pI == null) {
            return null;
        }
        return () -> {
            double R = pR.getAsDouble();
            double I = pI.getAsDouble();
            double P = R * I * I;
            return P / 150.0;
        };
    }

    private static void add(ItemBuilder<?, ?> builder, String suffix, double value) {
        class_2960 id = PowerGrid.asResource(builder.getName()).method_48331("." + suffix);
        DEFAULT_VALUES.put((Object)id, value);
    }

    public static <I extends WireItem, P> NonNullUnaryOperator<ItemBuilder<I, P>> set(double resistance, double maxLength, double thermalMass, double maxCurrent) {
        return builder -> {
            CWire.assertFromPowerGrid(builder);
            CWire.add(builder, "resistance", resistance);
            CWire.add(builder, "max-length", maxLength);
            CWire.add(builder, "thermal-mass", thermalMass);
            CWire.add(builder, "max-current", maxCurrent);
            return builder;
        };
    }

    private static void assertFromPowerGrid(ItemBuilder<?, ?> builder) {
        if (!builder.getOwner().getModid().equals("powergrid")) {
            throw new IllegalStateException("Non-Power Grid blocks cannot be added to Power Grid's config.");
        }
    }
}

