/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity;

import com.google.common.base.Objects;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.IElectricNode;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLine;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.network.packets.EndpointTrackingC2SPacket;
import org.patryk3211.powergrid.network.packets.TransmissionLineManagementS2CPacket;
import org.patryk3211.powergrid.network.packets.TransmissionLineStateS2CPacket;

@Environment(value=EnvType.CLIENT)
public class ClientWorldNetworks
extends WorldNetworks {
    private final Map<PhantomLine, PhantomLineData> phantomLines = new HashMap<PhantomLine, PhantomLineData>();

    public ClientWorldNetworks(class_1937 world) {
        super(world);
        this.perf.rename("ClientWorld");
    }

    @Override
    public void tick() {
        super.tick();
        Iterator<PhantomLineData> iter = this.phantomLines.values().iterator();
        while (iter.hasNext()) {
            PhantomLineData data = iter.next();
            data.tick();
            if (data.age <= 5) continue;
            data.remove();
            iter.remove();
        }
    }

    @Override
    @Nullable
    public ElectricWire makeTransmissionLine(IWireEndpoint endpoint1, IWireEndpoint endpoint2, BaseWireEntity forEntity, WorldNetworks.PartId id) {
        throw new IllegalCallerException("Not on the client");
    }

    private void removePhantomLines(TransmissionLine line) {
        PhantomLine key2;
        this.phantomLines.forEach((key, line2) -> line2.remove());
        this.phantomLines.clear();
        OwnedFloatingNode node1 = line.getNode1();
        OwnedFloatingNode node2 = line.getNode2();
        PhantomLine key1 = new PhantomLine(node1.endpoint, node2.endpoint);
        if (this.phantomLines.containsKey(key1)) {
            this.phantomLines.remove(key1).remove();
        }
        if (this.phantomLines.containsKey(key2 = new PhantomLine(node2.endpoint, node1.endpoint))) {
            this.phantomLines.remove(key2).remove();
        }
    }

    public void partialLine(TransmissionLineStateS2CPacket packet) {
        if (packet.endpoint1.isValid(this.world) && packet.endpoint2.isValid(this.world)) {
            OwnedFloatingNode node1 = packet.endpoint1.getNode(this.world);
            OwnedFloatingNode node2 = packet.endpoint2.getNode(this.world);
            Collection<AbstractElectricWire> wires = this.globalGraph.getWires(node1, node2);
            for (AbstractElectricWire wire : wires) {
                if (!(wire instanceof TransmissionLine)) continue;
                return;
            }
            PhantomLineData line1 = this.getPhantomLine(packet.endpoint1, packet.endpoint2, packet.lineResistance, packet.lineId, packet.node2Voltage);
            line1.setVoltage((packet.node2Voltage - packet.node1Voltage) / packet.lineResistance);
            PhantomLineData line2 = this.getPhantomLine(packet.endpoint2, packet.endpoint1, packet.lineResistance, packet.lineId, packet.node1Voltage);
            line2.setVoltage((packet.node1Voltage - packet.node2Voltage) / packet.lineResistance);
        } else if (packet.endpoint1.isValid(this.world)) {
            PhantomLineData line = this.getPhantomLine(packet.endpoint1, packet.endpoint2, packet.lineResistance, packet.lineId, packet.node2Voltage);
            line.setVoltage((packet.node2Voltage - packet.node1Voltage) / packet.lineResistance);
        } else if (packet.endpoint2.isValid(this.world)) {
            PhantomLineData line = this.getPhantomLine(packet.endpoint2, packet.endpoint1, packet.lineResistance, packet.lineId, packet.node1Voltage);
            line.setVoltage((packet.node1Voltage - packet.node2Voltage) / packet.lineResistance);
        }
    }

    private PhantomLineData getPhantomLine(IWireEndpoint endpoint1, IWireEndpoint endpoint2, float resistance, int lineId, float initialVoltage) {
        OwnedFloatingNode targetNode = endpoint1.getNode(this.world);
        if (targetNode.getNetwork() == null) {
            ElectricalNetwork network = this.newNetwork();
            endpoint1.joinNetwork(this.world, network);
        }
        PhantomLineData line = this.phantomLines.computeIfAbsent(new PhantomLine(endpoint1, endpoint2), key -> new PhantomLineData(targetNode, resistance, initialVoltage));
        if (line.source.getResistance() != resistance) {
            line.source.setResistance(resistance);
        }
        line.age = 0;
        line.lineId = lineId;
        return line;
    }

    @Override
    public void lineConnected(TransmissionLine line) {
        this.transmissionLines.put(line.getId(), line);
    }

    @Override
    public void lineDisconnected(TransmissionLine line) {
        this.transmissionLines.remove(line.getId());
        this.islandDiscoveryQueue.add(line.getNetwork());
    }

    @Override
    public void nodeHolderAdded(@NotNull OwnedFloatingNode ownedNode, boolean hasInternals) {
        OwnedFloatingNode oldNode = this.globalExternalNodes.put(ownedNode.endpoint, ownedNode);
        if (oldNode != null && oldNode != ownedNode) {
            this.nodeHolderRemoved(oldNode);
        }
        ModdedPackets.sendToServer(new EndpointTrackingC2SPacket(ownedNode, false));
    }

    @Override
    public void nodeHolderUnloaded(@NotNull OwnedFloatingNode ownedNode) {
        this.nodeHolderRemoved(ownedNode);
    }

    @Override
    public void nodeHolderRemoved(@NotNull OwnedFloatingNode ownedNode) {
        Set<TransmissionLine> lines = Set.copyOf(this.globalGraph.getConnectedLines(ownedNode));
        lines.forEach(line -> {
            this.removePhantomLines((TransmissionLine)line);
            line.remove();
        });
        super.nodeHolderRemoved(ownedNode);
        ModdedPackets.sendToServer(new EndpointTrackingC2SPacket(ownedNode, true));
    }

    @Override
    @Nullable
    public ElectricalNetwork prepareForConnection(IWireEndpoint endpoint1, IWireEndpoint endpoint2) {
        ElectricalNetwork network;
        OwnedFloatingNode node1 = endpoint1.getNode(this.world);
        OwnedFloatingNode node2 = endpoint2.getNode(this.world);
        this.add(endpoint1);
        this.add(endpoint2);
        if (node1 == node2) {
            return null;
        }
        if (node1 == null || node2 == null) {
            return null;
        }
        ElectricalNetwork net1 = node1.getNetwork();
        ElectricalNetwork net2 = node2.getNetwork();
        if (net1 == null && net2 == null) {
            network = this.newNetwork();
            endpoint1.joinNetwork(this.world, network);
            endpoint2.joinNetwork(this.world, network);
        } else if (net1 == null) {
            network = net2;
            endpoint1.joinNetwork(this.world, network);
        } else if (net2 == null) {
            network = net1;
            endpoint2.joinNetwork(this.world, network);
        } else if (net1 != net2) {
            if (net1.size() >= net2.size()) {
                network = net1;
                network.merge(net2);
            } else {
                network = net2;
                network.merge(net1);
            }
        } else {
            network = net1;
        }
        return network;
    }

    @Override
    @Nullable
    public ElectricalNetwork prepareForConnection(@NotNull OwnedFloatingNode node1, @NotNull OwnedFloatingNode node2) {
        ElectricalNetwork network;
        IWireEndpoint endpoint1 = node1.endpoint;
        IWireEndpoint endpoint2 = node2.endpoint;
        if (node1 == node2) {
            return null;
        }
        this.add(endpoint1);
        this.add(endpoint2);
        ElectricalNetwork net1 = node1.getNetwork();
        ElectricalNetwork net2 = node2.getNetwork();
        if (net1 == null && net2 == null) {
            network = this.newNetwork();
            endpoint1.joinNetwork(this.world, network);
            endpoint2.joinNetwork(this.world, network);
        } else if (net1 == null) {
            network = net2;
            endpoint1.joinNetwork(this.world, network);
        } else if (net2 == null) {
            network = net1;
            endpoint2.joinNetwork(this.world, network);
        } else if (net1 != net2) {
            if (net1.size() >= net2.size()) {
                network = net1;
                network.merge(net2);
            } else {
                network = net2;
                network.merge(net1);
            }
        } else {
            network = net1;
        }
        return network;
    }

    public void lineManagement(IWireEndpoint endpoint, TransmissionLineManagementS2CPacket.Entry[] entries) {
        IntOpenHashSet lines = this.globalGraph.getConnectedLines(endpoint.getNode(this.world)).stream().map(TransmissionLine::getId).collect(Collectors.toCollection(IntOpenHashSet::new));
        for (TransmissionLineManagementS2CPacket.Entry entry : entries) {
            if (!entry.endpoint1().isValid(this.world) || !entry.endpoint2().isValid(this.world)) continue;
            TransmissionLine line = (TransmissionLine)this.transmissionLines.get(entry.id());
            if (line != null) {
                lines.remove(line.getId());
                OwnedFloatingNode ln1 = line.getNode1();
                OwnedFloatingNode ln2 = line.getNode2();
                OwnedFloatingNode en1 = entry.endpoint1().getNode(this.world);
                OwnedFloatingNode en2 = entry.endpoint2().getNode(this.world);
                if (!(ln1 == en1 && ln2 == en2 || ln1 == en2 && ln2 == en1)) {
                    if (ln1 != en1) {
                        this.prepareForConnection(ln1, en1);
                        line.setNode1(entry.endpoint1(), en1);
                    }
                    if (ln2 != en2) {
                        this.prepareForConnection(ln2, en2);
                        line.setNode2(entry.endpoint2(), en2);
                    }
                }
                line.setResistance(entry.resistance());
            } else {
                OwnedFloatingNode node2;
                OwnedFloatingNode node1 = entry.endpoint1().getNode(this.world);
                ElectricalNetwork network = this.prepareForConnection(node1, node2 = entry.endpoint2().getNode(this.world));
                if (network == null) {
                    PowerGrid.LOGGER.warn("Failed to create a new transmission line from management packet");
                    return;
                }
                line = new TransmissionLine(entry.id(), entry.resistance(), node1, node2, this);
                network.addWire(line);
            }
            this.removePhantomLines(line);
        }
        for (Integer id : lines) {
            TransmissionLine line = (TransmissionLine)this.transmissionLines.get(id);
            line.remove();
        }
    }

    public float tryGetCurrent(int lineId) {
        TransmissionLine line = (TransmissionLine)this.transmissionLines.get(lineId);
        if (line != null) {
            return line.current();
        }
        for (PhantomLineData data : this.phantomLines.values()) {
            if (data.lineId != lineId) continue;
            return data.source.getCurrent();
        }
        return 0.0f;
    }

    private static class PhantomLineData {
        public final VoltageSourceCoupling source;
        public final IElectricNode node;
        public int age;
        public int lineId;
        public float current;

        public PhantomLineData(IElectricNode node, float resistance, float initialVoltage) {
            assert (node.getNetwork() != null);
            this.node = node;
            this.source = new VoltageSourceCoupling(node, null, resistance, initialVoltage);
            this.age = 0;
            ElectricalNetwork network = node.getNetwork();
            network.addNode((INode)this.source);
        }

        public void remove() {
            if (this.source.getNetwork() != null) {
                this.source.getNetwork().removeNode(this.source);
            }
        }

        public void tick() {
            ++this.age;
            if (this.current == 0.0f || !this.source.isConverged() || this.source.getCurrent() == 0.0f) {
                return;
            }
            float deltaI = this.source.getCurrent() + this.current;
            if (deltaI == 0.0f) {
                return;
            }
            this.source.setVoltage(this.source.getVoltage() + this.source.getResistance() * deltaI);
        }

        public void setVoltage(float targetCurrent) {
            this.current = targetCurrent;
        }
    }

    private record PhantomLine(IWireEndpoint endpoint, IWireEndpoint otherEndpoint) {
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PhantomLine) {
                PhantomLine line = (PhantomLine)obj;
                return this.endpoint.equals(line.endpoint) && this.otherEndpoint.equals(line.otherEndpoint);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.endpoint, this.otherEndpoint});
        }
    }
}

