/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_8563;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BaseWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.HangingWireEntity;

public class ElectricBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<ElectricBehaviour> TYPE = new BehaviourType();
    private final IElectricEntity element;
    private final List<INode> internalNodes = new ArrayList<INode>();
    private final List<OwnedFloatingNode> externalNodes = new ArrayList<OwnedFloatingNode>();
    private final List<AbstractElectricWire> internalWires = new ArrayList<AbstractElectricWire>();
    private final Map<BlockWireEndpoint, Set<BaseWireEntity>> connections = new HashMap<BlockWireEndpoint, Set<BaseWireEntity>>();
    private boolean destroying = false;
    private boolean rebuildOnClient = false;
    private boolean removed = false;
    private boolean paused = true;

    public <T extends SmartBlockEntity> ElectricBehaviour(T be) {
        this(be, true);
    }

    protected <T extends SmartBlockEntity> ElectricBehaviour(T be, boolean buildCircuit) {
        super(be);
        this.element = (IElectricEntity)be;
        if (buildCircuit) {
            IElectricEntity.CircuitBuilder builder = new IElectricEntity.CircuitBuilder(this.getPos(), this.externalNodes, this.internalNodes, this.internalWires);
            this.element.buildCircuit(builder);
        }
    }

    @Nullable
    public ElectricalNetwork getNetwork() {
        if (this.externalNodes.isEmpty()) {
            if (this.internalNodes.isEmpty()) {
                return null;
            }
            Iterator<INode> iterator = this.internalNodes.iterator();
            if (iterator.hasNext()) {
                INode node = iterator.next();
                return node.getNetwork();
            }
        }
        for (OwnedFloatingNode node : this.externalNodes) {
            if (node == null) continue;
            return node.getNetwork();
        }
        return null;
    }

    public void joinNetwork(ElectricalNetwork network) {
        if (this.externalNodes.isEmpty() && this.internalNodes.isEmpty()) {
            throw new IllegalStateException("Cannot join a network if no nodes are defined");
        }
        if (this.getNetwork() == null) {
            this.externalNodes.forEach(node -> {
                if (node != null) {
                    network.addNode((INode)node);
                }
            });
            if (!this.paused) {
                this.internalNodes.forEach(network::addNode);
                this.internalWires.forEach(network::addWire);
            }
        } else {
            this.externalNodes.forEach(node -> {
                if (node != null && node.getNetwork() == null) {
                    network.addNode((INode)node);
                }
            });
            if (!this.paused) {
                this.internalNodes.forEach(node -> {
                    if (node.getNetwork() == null) {
                        network.addNode((INode)node);
                    }
                });
                this.internalWires.forEach(wire -> {
                    if (wire.getNetwork() == null) {
                        network.addWire((AbstractElectricWire)wire);
                    }
                });
            }
        }
    }

    public void rebuildCircuit() {
        class_1937 world;
        IElectricEntity.CircuitBuilder builder = new IElectricEntity.CircuitBuilder(this.getPos(), this.externalNodes, this.internalNodes, this.internalWires);
        builder.with(this.getNetwork());
        if (this.paused) {
            builder.paused();
        }
        builder.clear();
        this.element.buildCircuit(builder);
        Iterator<Map.Entry<BlockWireEndpoint, Set<BaseWireEntity>>> iter = this.connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<BlockWireEndpoint, Set<BaseWireEntity>> entry = iter.next();
            BlockWireEndpoint endpoint = entry.getKey();
            if (endpoint.getTerminal() < this.externalNodes.size() && this.externalNodes.get(endpoint.getTerminal()) != null) {
                for (BaseWireEntity entity : entry.getValue()) {
                    entity.makeWire();
                }
                continue;
            }
            List<BaseWireEntity> connCopy = List.copyOf((Collection)entry.getValue());
            for (BaseWireEntity entity : connCopy) {
                entity.endpointRemoved(endpoint);
            }
            iter.remove();
        }
        if (this.getWorld() != null) {
            GlobalElectricNetworks.nodeHolderAdded(this);
        }
        if ((world = this.getWorld()) != null && !world.field_9236) {
            this.rebuildOnClient = true;
        }
    }

    public List<INode> getInternalNodes() {
        return this.internalNodes;
    }

    public List<OwnedFloatingNode> getExternalNodes() {
        return this.externalNodes;
    }

    public boolean isSafeNBT() {
        return true;
    }

    public void pause() {
        if (!this.paused) {
            this.paused = true;
            this.element.paused();
            this.internalWires.forEach(AbstractElectricWire::remove);
            ElectricalNetwork network = this.getNetwork();
            if (network != null) {
                for (int i = this.internalNodes.size() - 1; i >= 0; --i) {
                    INode node = this.internalNodes.get(i);
                    network.removeNode(node);
                }
            }
        }
    }

    public void unpause() {
        if (this.paused) {
            this.paused = false;
            ElectricalNetwork network = this.getNetwork();
            if (network == null) {
                return;
            }
            if (this.hasInternals()) {
                GlobalElectricNetworks.prepareUnpaused(this);
                this.internalNodes.forEach(network::addNode);
                this.internalWires.forEach(network::addWire);
                this.element.unpaused();
            }
        }
    }

    public void unload() {
        if (!this.removed) {
            this.pause();
            GlobalElectricNetworks.nodeHolderUnloaded(this);
        }
    }

    public void remove() {
        this.breakConnections();
        this.pause();
        GlobalElectricNetworks.nodeHolderRemoved(this);
        this.removed = true;
    }

    public void refreshConnectionEntities() {
        for (Map.Entry<BlockWireEndpoint, Set<BaseWireEntity>> entry : this.connections.entrySet()) {
            for (BaseWireEntity entity : entry.getValue()) {
                if (!(entity instanceof HangingWireEntity)) continue;
                HangingWireEntity wire = (HangingWireEntity)entity;
                wire.refreshTerminalPositions();
            }
        }
    }

    public void initialize() {
        super.initialize();
        GlobalElectricNetworks.nodeHolderAdded(this);
        this.unpause();
    }

    public void addConnection(BlockWireEndpoint endpoint, BaseWireEntity wire) {
        Set sourceConnections = this.connections.computeIfAbsent(endpoint, key -> new HashSet());
        sourceConnections.removeIf(class_1297::method_31481);
        sourceConnections.add(wire);
    }

    public void removeConnection(BlockWireEndpoint endpoint, BaseWireEntity wire) {
        if (!this.destroying && this.connections.containsKey(endpoint)) {
            Set<BaseWireEntity> list = this.connections.get(endpoint);
            list.remove(wire);
            if (list.isEmpty()) {
                this.connections.remove(endpoint);
            }
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Nullable
    public OwnedFloatingNode getTerminal(int index) {
        if (index >= this.externalNodes.size()) {
            return null;
        }
        return this.externalNodes.get(index);
    }

    public boolean hasConnection(BlockWireEndpoint source, BlockWireEndpoint destination) {
        if (!this.connections.containsKey(source)) {
            return false;
        }
        Set<BaseWireEntity> sourceConnections = this.connections.get(source);
        for (BaseWireEntity entity : sourceConnections) {
            if (!entity.isConnectedTo(destination.getPos(), destination.getTerminal())) continue;
            return true;
        }
        return false;
    }

    public Map<BlockWireEndpoint, Set<BaseWireEntity>> getConnections() {
        return this.connections;
    }

    public boolean hasTerminal(int terminal) {
        return terminal >= 0 && terminal < this.externalNodes.size() && this.externalNodes.get(terminal) != null;
    }

    public void breakConnections() {
        if (this.destroying) {
            return;
        }
        this.destroying = true;
        class_1937 world = this.getWorld();
        if (!world.field_9236) {
            for (Map.Entry<BlockWireEndpoint, Set<BaseWireEntity>> entry : this.connections.entrySet()) {
                BlockWireEndpoint endpoint = entry.getKey();
                for (BaseWireEntity entity : entry.getValue()) {
                    entity.endpointRemoved(endpoint);
                }
            }
            this.connections.clear();
        }
        this.destroying = false;
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (clientPacket && nbt.method_10577("Rebuild")) {
            this.rebuildCircuit();
        }
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (clientPacket && this.rebuildOnClient) {
            nbt.method_10556("Rebuild", true);
            this.rebuildOnClient = false;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.paused) {
            this.unpause();
        }
    }

    public void inheritConnections(ElectricBehaviour otherBehaviour) {
        for (Map.Entry<BlockWireEndpoint, Set<BaseWireEntity>> entry : otherBehaviour.connections.entrySet()) {
            Set thisList = this.connections.computeIfAbsent(entry.getKey(), key -> new HashSet());
            thisList.addAll((Collection)entry.getValue());
        }
        otherBehaviour.connections.clear();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean hasInternals() {
        return !this.internalNodes.isEmpty() || !this.internalWires.isEmpty();
    }

    public static void handleTicketChange(int newLevel, @NotNull class_3193 holder, int oldLevel) {
        block4: {
            class_2818 chunk;
            block3: {
                chunk = holder.method_16144();
                if (chunk == null) {
                    return;
                }
                if (class_8563.method_51832((int)newLevel) || !class_8563.method_51832((int)oldLevel)) break block3;
                for (class_2586 be : chunk.method_12214().values()) {
                    SmartBlockEntity smart;
                    ElectricBehaviour electric;
                    if (!(be instanceof SmartBlockEntity) || (electric = (ElectricBehaviour)(smart = (SmartBlockEntity)be).getBehaviour(TYPE)) == null) continue;
                    electric.pause();
                }
                break block4;
            }
            if (!class_8563.method_51832((int)newLevel)) break block4;
            for (class_2586 be : chunk.method_12214().values()) {
                SmartBlockEntity smart;
                ElectricBehaviour electric;
                if (!(be instanceof SmartBlockEntity) || (electric = (ElectricBehaviour)(smart = (SmartBlockEntity)be).getBehaviour(TYPE)) == null) continue;
                electric.unpause();
            }
        }
    }
}

