/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base;

import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedDamageTypes;
import org.patryk3211.powergrid.config.ThermalValues;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;

public class ThermalBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<ThermalBehaviour> TYPE = new BehaviourType("thermal");
    public static final float BASE_TEMPERATURE = 22.0f;
    public static final int OVERHEAT_TICKS = 2;
    public static final int OVERHEAT_PARTICLES = 1;
    public static final int OVERHEAT_EXPLOSION = 2;
    public static final int IGNORE_EXTRA_COOLING = 4;
    private float temperature;
    private float prevTemperature;
    private int overheatTicks;
    private float thermalMass;
    private float dissipationFactor;
    private final float overheatTemperature;
    private AirCurrent coolingAir;
    private float coolingFactorMultiplier;
    private class_2338 trackedBehaviour;
    private int behaviourFlags = 3;
    private Runnable overheatCallback;
    private boolean firstTick = true;

    protected ThermalBehaviour(SmartBlockEntity be, float thermalMass, float dissipationFactor, float overheatTemperature) {
        super(be);
        this.thermalMass = thermalMass;
        this.dissipationFactor = dissipationFactor;
        this.overheatTemperature = overheatTemperature;
        this.temperature = 22.0f;
        this.coolingFactorMultiplier = 1.0f;
        if (!ThermalBehaviour.shouldOverheat()) {
            this.behaviourFlags = 0;
        }
    }

    @Nullable
    public static ThermalBehaviour simple(SmartBlockEntity be, float thermalMass, float dissipationFactor, float overheatTemperature) {
        if (!ThermalBehaviour.shouldOverheat()) {
            return null;
        }
        return new ThermalBehaviour(be, thermalMass, dissipationFactor, overheatTemperature);
    }

    @NotNull
    public static ThermalBehaviour always(SmartBlockEntity be, float thermalMass, float dissipationFactor, float overheatTemperature) {
        return new ThermalBehaviour(be, thermalMass, dissipationFactor, overheatTemperature);
    }

    @Nullable
    public static ThermalBehaviour simple(SmartBlockEntity be, float thermalMass, float dissipationFactor) {
        return ThermalBehaviour.simple(be, thermalMass, dissipationFactor, 175.0f);
    }

    @Nullable
    public static ThermalBehaviour forMaxPower(SmartBlockEntity be, float thermalMass, float power) {
        return ThermalBehaviour.forMaxPower(be, thermalMass, power, 175.0f);
    }

    @Nullable
    public static ThermalBehaviour fromConfig(SmartBlockEntity be) {
        class_2248 block = be.method_11010().method_26204();
        return ThermalBehaviour.forMaxPower(be, ThermalValues.getMass(block), ThermalValues.getPower(block));
    }

    @Nullable
    public static ThermalBehaviour fromConfig(SmartBlockEntity be, float overheatTemperature) {
        class_2248 block = be.method_11010().method_26204();
        return ThermalBehaviour.forMaxPower(be, ThermalValues.getMass(block), ThermalValues.getPower(block), overheatTemperature);
    }

    public static float dissipationFactor(float power, float temperature) {
        return power / (temperature - 22.0f);
    }

    @Nullable
    public static ThermalBehaviour forMaxPower(SmartBlockEntity be, float thermalMass, float power, float overheatTemperature) {
        float targetTemperature = overheatTemperature - 25.0f;
        return ThermalBehaviour.simple(be, thermalMass, ThermalBehaviour.dissipationFactor(power, targetTemperature), overheatTemperature);
    }

    @Nullable
    public static <T extends SmartBlockEntity> ThermalBehaviour forVoltageAtResistance(T be, float voltage, float thermalMass) {
        return ThermalBehaviour.forVoltageAtResistance(be, voltage, ((IElectricEntity)be).resistance(), thermalMass, 175.0f);
    }

    @Nullable
    public static <T extends SmartBlockEntity> ThermalBehaviour forVoltageAtResistance(T be, float voltage, float resistance, float thermalMass) {
        return ThermalBehaviour.forMaxPower(be, thermalMass, voltage * voltage / resistance, 175.0f);
    }

    @Nullable
    public static <T extends SmartBlockEntity> ThermalBehaviour forVoltageAtResistance(T be, float voltage, float resistance, float thermalMass, float overheatTemperature) {
        return ThermalBehaviour.forMaxPower(be, thermalMass, voltage * voltage / resistance, overheatTemperature);
    }

    public static boolean shouldExplode() {
        return (Boolean)ModdedConfigs.server().electricity.explosiveDeconstruction.get();
    }

    public static boolean shouldOverheat() {
        return (Boolean)ModdedConfigs.server().electricity.overheating.get();
    }

    public ThermalBehaviour behaviourFlags(int flags) {
        this.behaviourFlags = flags;
        return this;
    }

    public ThermalBehaviour overheatCallback(Runnable callback) {
        this.overheatCallback = callback;
        return this;
    }

    public void track(@Nullable ThermalBehaviour other) {
        if (other == this || other == null) {
            this.trackedBehaviour = null;
            return;
        }
        this.trackedBehaviour = other.getPos();
    }

    public void resetTemperature() {
        this.temperature = 22.0f;
    }

    public void setDissipationFactor(float dissipationFactor) {
        this.dissipationFactor = dissipationFactor;
    }

    public void setThermalMass(float mass) {
        this.thermalMass = mass;
    }

    public void noCooling() {
        this.coolingFactorMultiplier = 1.0f;
        this.coolingAir = null;
    }

    public void setCoolingMultiplier(AirCurrent current, float value) {
        if ((this.behaviourFlags & 4) != 0) {
            return;
        }
        this.coolingFactorMultiplier = value;
        this.coolingAir = current;
    }

    public void tick() {
        ThermalBehaviour tracked;
        super.tick();
        if (this.firstTick) {
            this.firstTick = false;
            return;
        }
        ThermalBehaviour thermalBehaviour = tracked = this.trackedBehaviour != null ? (ThermalBehaviour)ThermalBehaviour.get((class_1922)this.getWorld(), (class_2338)this.trackedBehaviour, TYPE) : null;
        if (tracked != null) {
            this.temperature = tracked.temperature;
        }
        if (this.coolingAir != null && (this.coolingAir.source.isSourceRemoved() || this.coolingAir.source.getSpeed() == 0.0f)) {
            this.noCooling();
        }
        if (tracked == null) {
            float dissipatedPower = this.dissipationFactor * this.coolingFactorMultiplier * (this.temperature - 22.0f);
            this.temperature -= dissipatedPower / 20.0f / this.thermalMass;
            if (dissipatedPower > 0.0f && this.temperature < 22.0f) {
                this.temperature = 22.0f;
            }
            if (dissipatedPower != 0.0f) {
                this.blockEntity.method_5431();
            }
        }
        if (!Float.isFinite(this.temperature)) {
            this.temperature = 22.0f;
            this.prevTemperature = 22.0f;
        }
        float temperatureDelta = this.temperature - this.prevTemperature;
        this.prevTemperature = this.temperature;
        class_1937 world = this.getWorld();
        class_2338 pos = this.getPos();
        if (world.field_9236 && (this.behaviourFlags & 1) != 0) {
            class_5819 random = this.getWorld().method_8409();
            float x = (float)pos.method_10263() + random.method_43057();
            float y = (float)pos.method_10264() + random.method_43057();
            float z = (float)pos.method_10260() + random.method_43057();
            if (this.temperature >= this.overheatTemperature - 50.0f) {
                float chance = (this.temperature - this.overheatTemperature + 100.0f) / 100.0f;
                if (random.method_43057() < chance) {
                    world.method_8406((class_2394)class_2398.field_11251, (double)x, (double)y, (double)z, 0.0, (double)0.05f, 0.0);
                }
            }
        }
        if (this.isOverheated() && !world.field_9236) {
            if (temperatureDelta > 0.0f && this.overheatTicks++ >= 2) {
                if (this.overheatCallback != null) {
                    this.overheatCallback.run();
                }
                if ((this.behaviourFlags & 2) != 0) {
                    ThermalBehaviour.explode(world, pos, this.blockEntity.method_11010(), 1.0f);
                }
            } else if (temperatureDelta <= 0.0f) {
                this.overheatTicks = 0;
                if (this.temperature > this.overheatTemperature + 10.0f) {
                    this.temperature = this.overheatTemperature + 10.0f;
                    this.blockEntity.sendData();
                }
            }
        }
    }

    public static void explode(class_1937 world, class_2338 pos, class_2680 state, float power) {
        if (ThermalBehaviour.shouldExplode()) {
            class_2378 registry = world.method_30349().method_30530(class_7924.field_42534);
            MachineOverloadDamageSource source = new MachineOverloadDamageSource((class_6880<class_8110>)((class_6880)registry.method_40264(ModdedDamageTypes.OVERLOADED_MACHINE).get()), state.method_26204());
            world.method_22352(pos, false);
            world.method_8454(null, (class_1282)source, null, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), power, false, class_1937.class_7867.field_40889);
        } else {
            world.method_22352(pos, false);
        }
    }

    public boolean isOverheated() {
        return this.temperature >= this.overheatTemperature;
    }

    public void applyTickPower(float power) {
        if (Float.isFinite(power)) {
            float energy = power / 20.0f;
            this.temperature += energy / this.thermalMass;
        }
    }

    public void applyWirePower(AbstractElectricWire wire) {
        if (wire.isConverged()) {
            this.applyTickPower(wire.power());
        }
    }

    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.temperature = nbt.method_10583("Temperature");
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.method_10548("Temperature", this.temperature);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public static class MachineOverloadDamageSource
    extends class_1282 {
        private final class_2248 machine;

        public MachineOverloadDamageSource(class_6880<class_8110> type, class_2248 machine) {
            super(type);
            this.machine = machine;
        }

        public class_2561 method_5506(class_1309 killed) {
            String translationId = "death.attack." + this.method_48792().comp_1242();
            class_1309 primeAdversary = killed.method_6124();
            class_5250 machineName = class_2561.method_43471((String)this.machine.method_9539());
            if (primeAdversary != null) {
                return class_2561.method_43469((String)(translationId + ".player"), (Object[])new Object[]{killed.method_5476(), machineName, primeAdversary.method_5476()});
            }
            return class_2561.method_43469((String)translationId, (Object[])new Object[]{killed.method_5476(), machineName});
        }
    }
}

