/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base.terminals;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.class_2248;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.TerminalCollectionBuilder;

public class BlockStateTerminalCollection {
    private final Map<PartialState, TerminalBoundingBox[]> terminals;
    private final List<class_2769<?>> checkedProperties;
    private Function<class_2680, class_265> shapeMapper;
    private final int count;

    private BlockStateTerminalCollection(Map<PartialState, TerminalBoundingBox[]> terminals, List<class_2769<?>> checkedProperties, int count) {
        this.terminals = terminals;
        this.checkedProperties = checkedProperties;
        this.count = count;
    }

    public TerminalBoundingBox get(class_2680 state, int index) {
        TerminalBoundingBox[] value = this.terminals.get(PartialState.of(state, this.checkedProperties));
        if (value == null) {
            return null;
        }
        if (index < 0 || index >= value.length) {
            return null;
        }
        return value[index];
    }

    public int count() {
        return this.count;
    }

    public Function<class_2680, class_265> shapeMapper() {
        if (this.shapeMapper == null) {
            return null;
        }
        return state -> {
            TerminalBoundingBox[] terminals;
            class_265 baseShape = this.shapeMapper.apply((class_2680)state);
            for (TerminalBoundingBox terminal : terminals = this.terminals.get(PartialState.of(state, this.checkedProperties))) {
                if (terminal == null) continue;
                baseShape = class_259.method_1084((class_265)baseShape, (class_265)terminal.getShape());
            }
            return baseShape;
        };
    }

    public static TerminalBoundingBox[] each(TerminalBoundingBox[] input, UnaryOperator<TerminalBoundingBox> func) {
        TerminalBoundingBox[] copy = new TerminalBoundingBox[input.length];
        for (int i = 0; i < input.length; ++i) {
            copy[i] = input[i] == null ? null : (TerminalBoundingBox)func.apply(input[i]);
        }
        return copy;
    }

    public static Builder builder(class_2248 block) {
        return new Builder(block);
    }

    public static class PartialState
    implements Predicate<class_2680> {
        private final class_2248 block;
        private final Map<class_2769<?>, Comparable<?>> states;

        public PartialState(class_2248 block, Map<class_2769<?>, Comparable<?>> states) {
            this.block = block;
            this.states = states;
        }

        @Override
        public boolean test(class_2680 state) {
            if (!state.method_27852(this.block)) {
                return false;
            }
            for (Map.Entry<class_2769<?>, Comparable<?>> property : this.states.entrySet()) {
                if (state.method_11654(property.getKey()) == property.getValue()) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PartialState) {
                PartialState state = (PartialState)obj;
                return this.block == state.block && this.states.equals(state.states);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.block, this.states);
        }

        public static PartialState of(class_2680 state, Collection<class_2769<?>> properties) {
            HashMap map = new HashMap();
            for (class_2769<?> property : properties) {
                map.put(property, state.method_11654(property));
            }
            return new PartialState(state.method_26204(), map);
        }
    }

    public static class Builder
    implements TerminalCollectionBuilder<BlockStateTerminalCollection> {
        private final class_2248 block;
        private final Map<PartialState, TerminalBoundingBox[]> terminals;
        private Function<class_2680, class_265> shapeMapper = null;

        private Builder(class_2248 block) {
            this.block = block;
            this.terminals = new HashMap<PartialState, TerminalBoundingBox[]>();
        }

        public Builder forAllStates(Function<class_2680, TerminalBoundingBox[]> mapper) {
            return this.forAllStatesExcept(mapper, new class_2769[0]);
        }

        public Builder forAllStatesExcept(Function<class_2680, TerminalBoundingBox[]> mapper, class_2769<?> ... ignored) {
            HashSet<PartialState> seen = new HashSet<PartialState>();
            ImmutableList states = this.block.method_9595().method_11662();
            for (class_2680 state : states) {
                LinkedHashMap properties = Maps.newLinkedHashMap((Map)state.method_11656());
                for (class_2769<?> prop : ignored) {
                    properties.remove(prop);
                }
                PartialState partial = new PartialState(this.block, properties);
                if (!seen.add(partial)) continue;
                this.terminals.put(partial, mapper.apply(state));
            }
            return this;
        }

        public Builder withShapeMapper(Function<class_2680, class_265> mapper) {
            this.shapeMapper = mapper;
            return this;
        }

        @Override
        public BlockStateTerminalCollection build() {
            Set<class_2769<?>> checkedProperties = null;
            int count = 0;
            for (PartialState state : this.terminals.keySet()) {
                if (checkedProperties == null) {
                    checkedProperties = state.states.keySet();
                    count = this.terminals.get(state).length;
                    continue;
                }
                if (!checkedProperties.equals(state.states.keySet())) {
                    throw new IllegalStateException("All partial states must check the same property set");
                }
                if (this.terminals.get(state).length == count) continue;
                throw new IllegalStateException("All states must map the same number of terminals");
            }
            BlockStateTerminalCollection collection = checkedProperties != null ? new BlockStateTerminalCollection(this.terminals, Lists.newArrayList(checkedProperties), count) : new BlockStateTerminalCollection(this.terminals, List.of(), count);
            collection.shapeMapper = this.shapeMapper;
            return collection;
        }
    }
}

