/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.base.terminals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.SimpleTerminalCollectionBuilder;

public class RotatedTerminalCollection {
    private final TerminalBoundingBox[][] terminals;

    private RotatedTerminalCollection(TerminalBoundingBox[][] terminals) {
        this.terminals = terminals;
    }

    public TerminalBoundingBox get(class_2350 dir, int index) {
        return this.terminals[dir.ordinal()][index];
    }

    public static Builder builder(ITerminalRotator rotator) {
        return new Builder(rotator);
    }

    public static TerminalBoundingBox rotateNorthToFacing(TerminalBoundingBox terminal, class_2350 facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> terminal;
            case class_2350.field_11035 -> terminal.rotateAroundY(class_2470.field_11464);
            case class_2350.field_11034 -> terminal.rotateAroundY(class_2470.field_11463);
            case class_2350.field_11039 -> terminal.rotateAroundY(class_2470.field_11465);
            case class_2350.field_11036 -> terminal.rotateAroundX(class_2470.field_11465);
            case class_2350.field_11033 -> terminal.rotateAroundX(class_2470.field_11463);
        };
    }

    public static class Builder
    extends SimpleTerminalCollectionBuilder<Builder, RotatedTerminalCollection> {
        private final ITerminalRotator rotator;
        private final List<class_2350> directions = new ArrayList<class_2350>();

        private Builder(ITerminalRotator rotator) {
            this.rotator = rotator;
        }

        public Builder with(class_2350 direction) {
            this.directions.add(direction);
            return this;
        }

        public Builder with(class_2350 ... directions) {
            Collections.addAll(this.directions, directions);
            return this;
        }

        @Override
        public RotatedTerminalCollection build() {
            TerminalBoundingBox[][] terminals = new TerminalBoundingBox[6][this.terminals.size()];
            for (class_2350 dir : this.directions) {
                for (int i = 0; i < this.terminals.size(); ++i) {
                    terminals[dir.ordinal()][i] = this.rotator.rotate((TerminalBoundingBox)this.terminals.get(i), dir);
                }
            }
            return new RotatedTerminalCollection(terminals);
        }
    }

    public static interface ITerminalRotator {
        public TerminalBoundingBox rotate(TerminalBoundingBox var1, class_2350 var2);
    }
}

