/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.battery.AbstractBatteryBlock;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;
import org.patryk3211.powergrid.electricity.battery.CustomConnectivityHandler;
import org.patryk3211.powergrid.electricity.battery.MultiBlockBatteryEntity;
import org.patryk3211.powergrid.electricity.deviceconnector.IAcceptConnector;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Power;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.utility.Lang;

public class BatteryBlock
extends AbstractBatteryBlock<MultiBlockBatteryEntity>
implements IAcceptConnector,
IHaveElectricProperties {
    protected BatterySpec spec;

    public BatteryBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public static <T extends BatteryBlock, P> NonNullUnaryOperator<BlockBuilder<T, P>> setSpec(BatterySpec spec) {
        return b -> (BlockBuilder)b.onRegister(block -> {
            block.spec = spec;
        });
    }

    @Override
    public BatterySpec getSpec() {
        return this.spec;
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean moved) {
        if (oldState.method_26204() == state.method_26204()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((class_1922)world, pos, MultiBlockBatteryEntity::queueConnectivityUpdate);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_31709() && (state.method_26204() != newState.method_26204() || !newState.method_31709())) {
            class_2586 be = world.method_8321(pos);
            if (!(be instanceof MultiBlockBatteryEntity)) {
                return;
            }
            MultiBlockBatteryEntity battery = (MultiBlockBatteryEntity)be;
            List<TransmissionLinePart> wires = GlobalElectricNetworks.getWorldNetworks(world).findConnectedWires(battery.getElectricBehaviour());
            super.method_9536(state, world, pos, newState, moved);
            CustomConnectivityHandler.splitMulti(battery);
            wires.forEach(TransmissionLinePart::refreshEndpointNodes);
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List stacks = super.method_9560(state, builder);
        class_2586 be = (class_2586)builder.method_51876(class_181.field_1228);
        if (be instanceof MultiBlockBatteryEntity) {
            MultiBlockBatteryEntity battery = (MultiBlockBatteryEntity)be;
            for (class_1799 stack : stacks) {
                if (!stack.method_31574(this.method_8389())) continue;
                class_2487 tag = stack.method_7948();
                tag.method_10549("Energy", Math.floor(battery.getIndividualEnergy()));
                break;
            }
        }
        return stacks;
    }

    public Class<MultiBlockBatteryEntity> getBlockEntityClass() {
        return MultiBlockBatteryEntity.class;
    }

    public class_2591<? extends MultiBlockBatteryEntity> getBlockEntityType() {
        return (class_2591)ModdedBlockEntities.MULTIBLOCK_BATTERY.get();
    }

    @Override
    public boolean isPolarized() {
        return true;
    }

    @Override
    public void appendProperties(class_1799 stack, class_1657 player, List<class_2561> tooltip) {
        Voltage.max(this.spec.calculateVoltage(1.0f), player, tooltip);
        Power.max(stack, player, tooltip);
        float charge = !stack.method_7985() || !stack.method_7969().method_10545("Energy") ? this.getSpec().getInitialCharge() / this.getSpec().getMaxCharge() : (float)(stack.method_7969().method_10574("Energy") / (double)this.getSpec().getMaxCharge());
        Lang.translate("tooltip.charge.current", new Object[0]).style(class_124.field_1080).addTo(tooltip);
        Lang.builder().add(class_2561.method_43470((String)" ")).add(Lang.numberConstant(charge * 100.0f)).add(class_2561.method_43470((String)"%")).style(class_124.field_1075).addTo(tooltip);
    }
}

