/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.battery;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.patryk3211.powergrid.config.ThermalValues;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.WorldNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ProxyElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.battery.BatteryBlockEntity;
import org.patryk3211.powergrid.electricity.battery.BatterySpec;
import org.patryk3211.powergrid.electricity.battery.CustomConnectivityHandler;
import org.patryk3211.powergrid.electricity.battery.IMultiBlockBattery;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;

public class MultiBlockBatteryEntity
extends BatteryBlockEntity
implements IMultiBlockBattery {
    protected int width = 1;
    protected int height = 1;
    protected boolean updateConnectivity;
    private boolean rewire;
    protected class_2338 lastKnownPos;
    protected class_2338 controller;

    public MultiBlockBatteryEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        this.updateBehaviour();
        this.sendData();
    }

    @Override
    public void updateParameters() {
        if (this.energy <= 0.0 || this.sourceCoupling == null) {
            return;
        }
        float chargeLevel = (float)(this.energy / this.capacity);
        this.sourceCoupling.setVoltage(this.spec.calculateVoltage(chargeLevel));
        this.sourceCoupling.setResistance(this.spec.calculateResistance(chargeLevel) / (float)this.getSize());
    }

    private void overheated() {
        assert (this.field_11863 != null);
        if (this.isController()) {
            GlobalElectricNetworks.getWorldNetworks(this.field_11863).findConnectedWires(this.electricBehaviour).forEach(wire -> {
                if (wire.owner != null) {
                    wire.owner.method_5768();
                } else {
                    wire.remove();
                }
            });
            class_5819 r = this.field_11863.field_9229;
            int x = this.field_11867.method_10263() + r.method_43051(0, this.getWidth());
            int y = this.field_11867.method_10264() + r.method_43051(0, this.getHeight());
            int z = this.field_11867.method_10260() + r.method_43051(0, this.getWidth());
            ThermalBehaviour.explode(this.field_11863, new class_2338(x, y, z), this.method_11010(), (float)this.getSize() * 0.25f);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.electricBehaviour = this.isController() ? new ElectricBehaviour(this) : new ProxyElectricBehaviour(this, this::getController);
        behaviours.add(this.electricBehaviour);
        this.thermalBehaviour = this.specifyThermalBehaviour();
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.behaviourFlags(1).overheatCallback(this::overheated);
            behaviours.add(this.thermalBehaviour);
        }
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        CustomConnectivityHandler.formMulti(this);
    }

    @Override
    public void updateBehaviour() {
        List<TransmissionLinePart> wires = null;
        if (this.field_11863 != null) {
            wires = GlobalElectricNetworks.getWorldNetworks(this.field_11863).findConnectedWires(this.electricBehaviour);
        }
        if (this.isController()) {
            ElectricBehaviour electricBehaviour = this.electricBehaviour;
            if (electricBehaviour instanceof ProxyElectricBehaviour) {
                ProxyElectricBehaviour proxy = (ProxyElectricBehaviour)electricBehaviour;
                this.electricBehaviour = new ElectricBehaviour(this);
                this.electricBehaviour.inheritConnections(proxy);
                this.attachBehaviourLate(this.electricBehaviour);
            }
            this.updateThermals();
            if (this.thermalBehaviour != null) {
                this.thermalBehaviour.track(null);
            }
        } else {
            MultiBlockBatteryEntity controller;
            if (!(this.electricBehaviour instanceof ProxyElectricBehaviour)) {
                ElectricBehaviour old = this.electricBehaviour;
                this.electricBehaviour = new ProxyElectricBehaviour(this, this::getController);
                this.electricBehaviour.inheritConnections(old);
                old.pause();
                this.attachBehaviourLate(this.electricBehaviour);
                this.sourceCoupling = null;
            }
            if ((controller = this.getControllerBE()) != null && this.thermalBehaviour != null) {
                this.thermalBehaviour.track(controller.thermalBehaviour);
            }
        }
        if (wires != null) {
            wires.forEach(TransmissionLinePart::refreshEndpointNodes);
        }
        this.updateParameters();
    }

    @Override
    public void markRewire() {
        this.rewire = true;
        this.sendData();
    }

    @Override
    public void tick() {
        MultiBlockBatteryEntity controller;
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.method_11016();
        } else if (!this.lastKnownPos.equals((Object)this.field_11867)) {
            this.onPositionChanged();
            return;
        }
        if (!this.isController() && (controller = this.getControllerBE()) != null && this.thermalBehaviour != null) {
            this.thermalBehaviour.track(this.getControllerBE().thermalBehaviour);
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.field_11863.field_9236 && this.rewire) {
            this.updateBehaviour();
            this.rewire = false;
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    public MultiBlockBatteryEntity getControllerBE() {
        if (this.isController() || !this.method_11002()) {
            return this;
        }
        class_2586 blockEntity = this.field_11863.method_8321(this.controller);
        if (blockEntity instanceof MultiBlockBatteryEntity) {
            MultiBlockBatteryEntity battery = (MultiBlockBatteryEntity)blockEntity;
            return battery;
        }
        return null;
    }

    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    public void setController(class_2338 controller) {
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.updateBehaviour();
        this.notifyUpdate();
    }

    public void removeController(boolean keepContents) {
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepContents) {
            double currentBlocks = (double)this.spec.getMaxCharge() / this.capacity;
            this.capacity = this.spec.getMaxCharge();
            this.energy /= currentBlocks;
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.updateBehaviour();
        this.notifyUpdate();
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        boolean changeOfController;
        class_2338 controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = compound.method_10545("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.method_10545("LastKnownPos")) {
            this.lastKnownPos = class_2512.method_10691((class_2487)compound.method_10562("LastKnownPos"));
        }
        if (compound.method_10545("Controller")) {
            this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
        }
        if (this.isController()) {
            this.width = compound.method_10550("Size");
            this.height = compound.method_10550("Height");
        }
        int blocks = this.width * this.width * this.height;
        this.capacity = this.spec.getMaxCharge() * (float)blocks;
        super.read(compound, clientPacket);
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.field_11863 != null && (changeOfController || prevSize != this.width || prevHeight != this.height)) {
            this.field_11863.method_16109(this.method_11016(), class_2246.field_10124.method_9564(), this.method_11010());
            this.updateBehaviour();
        }
        if (clientPacket && compound.method_10577("Rewire")) {
            this.rewire = true;
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.method_10556("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        if (this.isController()) {
            compound.method_10569("Size", this.width);
            compound.method_10569("Height", this.height);
        }
        super.write(compound, clientPacket);
        if (clientPacket && this.rewire) {
            compound.method_10556("Rewire", true);
            this.rewire = false;
        }
    }

    public double getIndividualEnergy() {
        MultiBlockBatteryEntity controller = this.getControllerBE();
        if (controller == null) {
            return this.getEnergy();
        }
        return controller.getEnergy() / (double)controller.getSize();
    }

    public void invalidate() {
        if (this.field_11863.field_9236) {
            WorldNetworks global = GlobalElectricNetworks.getWorldNetworks(this.field_11863);
            List<TransmissionLinePart> wires = global.findConnectedWires(this.electricBehaviour);
            global.deferredRewire(wires);
        }
        super.invalidate();
    }

    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void queueConnectivityUpdate() {
        this.updateConnectivity = true;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        if (this.isController()) {
            this.capacity = this.spec.getMaxCharge() * (float)this.getSize();
            this.updateThermals();
            this.updateParameters();
        }
        this.notifyUpdate();
    }

    private void updateThermals() {
        if (this.thermalBehaviour != null) {
            class_2248 block = this.method_11010().method_26204();
            float factor = ThermalBehaviour.dissipationFactor(ThermalValues.getPower(block), 175.0f);
            this.thermalBehaviour.setDissipationFactor(factor * (float)this.getSize());
            this.thermalBehaviour.setThermalMass(ThermalValues.getMass(block) * (float)this.getSize());
        }
    }

    public class_2350.class_2351 getMainConnectionAxis() {
        return class_2350.class_2351.field_11052;
    }

    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052) {
            return 5;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public BatterySpec getSpec() {
        return this.spec;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public void inheritEnergy(IMultiBlockBattery part) {
        this.energy += part.getEnergy();
        part.setEnergy(0.0);
    }

    @Override
    public void setCapacitySize(int blocks) {
        this.capacity = this.spec.getMaxCharge() * (float)blocks;
    }

    @Override
    public int getSize() {
        return Math.max(this.width * this.width * this.height, 1);
    }
}

