/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.deviceconnector;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ProxyElectricBehaviour;
import org.patryk3211.powergrid.electricity.deviceconnector.fabric.BridgeElectricBehaviourImpl;
import org.patryk3211.powergrid.electricity.febridge.IFEBridgeHandler;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;

public class BridgeElectricBehaviour
extends ProxyElectricBehaviour {
    private IFEBridgeHandler bridgeBehaviour;
    private long readEnergy;
    public long currentRate;
    private boolean fetched = false;
    private final Supplier<SwitchedWire> converterWire;
    private boolean isProxy = false;

    public <T extends SmartBlockEntity> BridgeElectricBehaviour(T be, class_2338 behaviourPosition, Supplier<SwitchedWire> converterWire) {
        super(be, true, () -> behaviourPosition);
        this.converterWire = converterWire;
    }

    protected void constructBehaviours() {
        class_1937 world = this.getWorld();
        if (!world.method_8477((class_2338)this.behaviourPosition.get())) {
            return;
        }
        this.fetched = true;
        ElectricBehaviour mainBehaviour = (ElectricBehaviour)BridgeElectricBehaviour.get((class_1922)world, (class_2338)((class_2338)this.behaviourPosition.get()), (BehaviourType)TYPE);
        if (mainBehaviour != null) {
            this.isProxy = true;
            return;
        }
        this.bridgeBehaviour = BridgeElectricBehaviour.makeFEHandler((class_2586)this.blockEntity);
        if (this.bridgeBehaviour == null) {
            world.method_22352(this.getPos(), true);
            return;
        }
        this.bridgeBehaviour.setAmount(this.readEnergy);
    }

    @Override
    public Optional<ElectricBehaviour> getMainBehaviour() {
        if (!this.fetched) {
            this.constructBehaviours();
        }
        return super.getMainBehaviour();
    }

    @Nullable
    public IFEBridgeHandler getBridgeBehaviour() {
        if (!this.fetched) {
            this.constructBehaviours();
        }
        return this.bridgeBehaviour;
    }

    protected boolean isProxy() {
        if (!this.fetched) {
            this.constructBehaviours();
        }
        return this.isProxy;
    }

    @Override
    public void initialize() {
        if (this.isProxy()) {
            super.initialize();
        } else {
            super.baseInitialize();
        }
    }

    @Override
    public void unload() {
        if (!this.isProxy()) {
            super.baseUnload();
        }
    }

    @Override
    public void remove() {
        if (this.isProxy()) {
            super.remove();
        } else {
            super.baseRemove();
        }
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (this.bridgeBehaviour != null) {
            this.bridgeBehaviour.setAmount(nbt.method_10537("Energy"));
        } else {
            this.readEnergy = nbt.method_10537("Energy");
        }
        if (clientPacket) {
            this.currentRate = nbt.method_10537("Rate");
        }
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.bridgeBehaviour != null) {
            nbt.method_10544("Energy", this.bridgeBehaviour.getAmount());
            if (clientPacket) {
                nbt.method_10544("Rate", this.currentRate);
            }
        }
    }

    public void tick() {
        super.tick();
        IFEBridgeHandler energyStorage = this.getBridgeBehaviour();
        if (energyStorage == null) {
            return;
        }
        SwitchedWire wire = this.converterWire.get();
        class_1937 world = this.getWorld();
        energyStorage.charge(wire);
        long moved = energyStorage.moveEnergy();
        if (!world.field_9236) {
            if (moved != this.currentRate) {
                this.currentRate = moved;
                this.blockEntity.sendData();
            }
        } else if (moved == 0L) {
            long amount = energyStorage.getAmount();
            energyStorage.setAmount(Math.max(amount - this.currentRate, 0L));
        }
        energyStorage.manageWire(wire);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFEBridgeHandler makeFEHandler(class_2586 be) {
        return BridgeElectricBehaviourImpl.makeFEHandler(be);
    }

    public boolean isFE() {
        return this.bridgeBehaviour != null;
    }

    public long getBufferedAmount() {
        return this.bridgeBehaviour.getAmount();
    }
}

