/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.deviceconnector;

import com.simibubi.create.foundation.block.IBE;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.electricity.base.ElectricBlock;
import org.patryk3211.powergrid.electricity.base.IDecoratedTerminal;
import org.patryk3211.powergrid.electricity.base.TerminalBoundingBox;
import org.patryk3211.powergrid.electricity.base.terminals.BlockStateTerminalCollection;
import org.patryk3211.powergrid.electricity.deviceconnector.DeviceConnectorBlockEntity;
import org.patryk3211.powergrid.electricity.deviceconnector.IAcceptConnector;
import org.patryk3211.powergrid.electricity.deviceconnector.fabric.DeviceConnectorBlockImpl;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.IAcceptCord;
import org.patryk3211.powergrid.utility.proxy.ProxyProvider;
import org.patryk3211.powergrid.utility.proxy.TFMGProxy;

public class DeviceConnectorBlock
extends ElectricBlock
implements IBE<DeviceConnectorBlockEntity>,
IAcceptCord {
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2758 ROTATION = CustomProperties.ROTATION_4;
    public static final class_2746 POLARIZED = class_2746.method_11825((String)"polarized");
    private final TerminalBoundingBox[] TERMINALS_DOWN = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 5.5, 1.0, 1.5, 10.5, 4.0, 4.5), new TerminalBoundingBox(IDecoratedTerminal.CONNECTOR, 5.5, 1.0, 11.5, 10.5, 4.0, 14.5)};
    private final TerminalBoundingBox[] POLARIZED_TERMINALS_DOWN = new TerminalBoundingBox[]{new TerminalBoundingBox(IDecoratedTerminal.POSITIVE, 5.5, 1.0, 1.5, 10.5, 4.0, 4.5).withColor(0xFF3B3B), new TerminalBoundingBox(IDecoratedTerminal.NEGATIVE, 5.5, 1.0, 11.5, 10.5, 4.0, 14.5).withColor(3899647)};
    private static final class_265 SHAPE_DOWN = DeviceConnectorBlock.method_9541((double)4.5, (double)0.0, (double)3.5, (double)11.5, (double)4.0, (double)12.5);
    private static final class_265 SHAPE_DOWN_2 = DeviceConnectorBlock.method_9541((double)3.5, (double)0.0, (double)4.5, (double)12.5, (double)4.0, (double)11.5);

    public DeviceConnectorBlock(class_4970.class_2251 settings) {
        super(settings);
        VoxelShaper shaper = VoxelShaper.forDirectional((class_265)SHAPE_DOWN, (class_2350)class_2350.field_11033);
        VoxelShaper shaper2 = VoxelShaper.forDirectional((class_265)SHAPE_DOWN_2, (class_2350)class_2350.field_11033);
        this.setTerminalCollection(BlockStateTerminalCollection.builder(this).forAllStates(state -> BlockStateTerminalCollection.each((Boolean)state.method_11654((class_2769)POLARIZED) != false ? this.POLARIZED_TERMINALS_DOWN : this.TERMINALS_DOWN, terminal -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            terminal = switch (facing) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11033 -> terminal;
                case class_2350.field_11036 -> terminal.rotateAroundX(180);
                case class_2350.field_11034 -> terminal.rotateAroundZ(-90);
                case class_2350.field_11039 -> terminal.rotateAroundZ(90);
                case class_2350.field_11043 -> terminal.rotateAroundZ(90).rotateAroundY(90);
                case class_2350.field_11035 -> terminal.rotateAroundZ(90).rotateAroundY(-90);
            };
            Integer rotation = (Integer)state.method_11654((class_2769)ROTATION);
            terminal = terminal.rotate(facing.method_10166(), 90 * rotation - 90);
            return terminal;
        })).withShapeMapper(state -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            Integer rotation = (Integer)state.method_11654((class_2769)ROTATION);
            boolean axis_along = rotation % 2 == 1;
            VoxelShaper prov = axis_along ^ facing.method_10166() == class_2350.class_2351.field_11052 ? shaper2 : shaper;
            return prov.get(facing);
        }).build());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, ROTATION, POLARIZED});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        IAcceptConnector acceptor;
        boolean polarized;
        class_2350 facing = ctx.method_8038().method_10153();
        int rotation = 0;
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            class_2350 player = ctx.method_8042();
            rotation = player.method_10161();
        } else {
            rotation = 1;
        }
        class_2680 neighbor = ctx.method_8045().method_8320(ctx.method_8037().method_10093(facing));
        class_2248 class_22482 = neighbor.method_26204();
        boolean bl = polarized = class_22482 instanceof IAcceptConnector && (acceptor = (IAcceptConnector)class_22482).isPolarized();
        if (ctx.method_8036() != null && ctx.method_8036().method_5715()) {
            rotation = (rotation + 2) % 3;
        }
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)ROTATION, (Comparable)Integer.valueOf(rotation))).method_11657((class_2769)POLARIZED, (Comparable)Boolean.valueOf(polarized));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean hasEnergyStorage(class_1937 world, class_2338 pos, class_2350 side) {
        void var2_2;
        void var1_1;
        return DeviceConnectorBlockImpl.hasEnergyStorage(world, (class_2338)var1_1, (class_2350)var2_2);
    }

    public static class_265 makeCheckShape(class_2350 side) {
        Vector3f min = new Vector3f(0.375f);
        Vector3f max = new Vector3f(0.625f);
        switch (side.method_10166()) {
            case field_11048: {
                min.x = 0.0f;
                max.x = 1.0f;
                break;
            }
            case field_11052: {
                min.y = 0.0f;
                max.y = 1.0f;
                break;
            }
            case field_11051: {
                min.z = 0.0f;
                max.z = 1.0f;
            }
        }
        return class_259.method_1081((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public static boolean canSupport(class_4538 world, class_2338 pos, class_2680 state, class_2350 side) {
        class_265 connectorShape = DeviceConnectorBlock.makeCheckShape(side);
        class_265 shape = state.method_26220((class_1922)world, pos);
        return class_259.method_1083((class_265)connectorShape, (class_265)shape, (class_2350)side.method_10153());
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_1937 world1;
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 neighborPos = pos.method_10093(facing);
        class_2680 neighbor = world.method_8320(neighborPos);
        if (neighbor.method_26204() == this) {
            return false;
        }
        if (world instanceof class_1937 && DeviceConnectorBlock.hasEnergyStorage(world1 = (class_1937)world, neighborPos, facing.method_10153())) {
            return DeviceConnectorBlock.canSupport(world, neighborPos, neighbor, facing.method_10153());
        }
        if (ProxyProvider.get(TFMGProxy.class).map(proxy -> proxy.canConnect(world, neighborPos, facing.method_10153())).orElse(false).booleanValue()) {
            return true;
        }
        class_2248 class_22482 = neighbor.method_26204();
        if (!(class_22482 instanceof IAcceptConnector)) {
            return false;
        }
        IAcceptConnector acceptor = (IAcceptConnector)class_22482;
        return acceptor.canConnect(world, neighborPos, neighbor, facing.method_10153());
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        if (!this.method_9558(state, (class_4538)world, pos)) {
            world.method_22352(pos, true);
        }
    }

    public Class<DeviceConnectorBlockEntity> getBlockEntityClass() {
        return DeviceConnectorBlockEntity.class;
    }

    public class_2591<? extends DeviceConnectorBlockEntity> getBlockEntityType() {
        return (class_2591)ModdedBlockEntities.DEVICE_CONNECTOR.get();
    }

    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        if (targetedFace.method_10166() == ((class_2350)originalState.method_11654((class_2769)FACING)).method_10166()) {
            return (class_2680)originalState.method_28493((class_2769)ROTATION);
        }
        return super.getRotatedBlockState(originalState, targetedFace);
    }

    @Override
    @Nullable
    public AutoCordEndpoint getEndpoint(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = level.method_8320(pos);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_243 center = class_243.method_24953((class_2382)pos);
        class_2382 normal = facing.method_10163();
        class_243 point = center.method_1031((double)normal.method_10263() * 0.3125, (double)normal.method_10264() * 0.3125, (double)normal.method_10260() * 0.3125);
        return new AutoCordEndpoint(context.method_8037(), 0, 1, point, this.renderPlug() ? context.method_8038() : null);
    }
}

