/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.electricswitch;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.electricswitch.HvSwitchBlock;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.kinetics.base.ElectricKineticBlockEntity;

public class HvSwitchBlockEntity
extends ElectricKineticBlockEntity {
    protected LerpedFloat rod = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);
    private SwitchedWire wire;
    private int state = 1;

    public HvSwitchBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig((SmartBlockEntity)this);
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        class_2350 facing = (class_2350)this.method_11010().method_11654(HvSwitchBlock.HORIZONTAL_FACING);
        if (facing == class_2350.field_11043 || facing == class_2350.field_11034) {
            speed = -speed;
        }
        this.rod.chase(speed > 0.0f ? 1.0 : 0.0, (double)this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    private float getChaseSpeed() {
        return class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 21.0f / 20.0f), (float)0.0f, (float)1.0f);
    }

    public void initialize() {
        super.initialize();
        this.wire.setState(false);
        this.wire.setResistance(this.getResistance());
        this.wire.setState(this.isClosed());
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        this.rod.tickChaser();
        if (!(this.rod.settled() || this.wire.getState() == this.isClosed() && this.wire.getResistance() == (double)this.getResistance())) {
            this.wire.setState(false);
            this.wire.setResistance(this.getResistance());
            this.wire.setState(this.isClosed());
            this.method_5431();
        }
    }

    public void tickAudio() {
        assert (this.field_11863 != null);
        super.tickAudio();
        int newState = 1;
        if (this.rod.getValue() == 1.0f) {
            newState = 2;
        }
        if (this.rod.getValue() == 0.0f) {
            newState = 0;
        }
        if (newState != this.state) {
            this.state = newState;
            if (this.state == 2) {
                this.field_11863.method_45446(this.method_11016(), ModdedSoundEvents.HV_SWITCH_DISCONNECT.getMainEvent(), class_3419.field_15245, 1.0f, 1.0f, true);
            } else if (this.state == 0) {
                this.field_11863.method_45446(this.method_11016(), ModdedSoundEvents.HV_SWITCH_CONNECT.getMainEvent(), class_3419.field_15245, 1.0f, 1.0f, true);
            }
        }
    }

    public boolean isClosed() {
        if (this.rod == null) {
            return false;
        }
        return this.rod.getValue() > 0.9f;
    }

    public float getResistance() {
        if (this.rod == null || !this.isClosed()) {
            return this.resistance();
        }
        float x = this.rod.getValue();
        return -999.0f * x + 999.0f + this.resistance();
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10566("Rod", (class_2520)this.rod.writeNBT());
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        tag.method_10566("Rod", (class_2520)this.rod.writeNBT());
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.rod.readNBT(compound.method_10562("Rod"), false);
        if (this.wire != null) {
            this.wire.setState(false);
            this.wire.setResistance(this.getResistance());
            this.wire.setState(this.isClosed());
        }
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connectSwitch(this.getResistance(), builder.terminalNode(0), builder.terminalNode(1), this.isClosed());
    }
}

