/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.gauge;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.PercentOrProgressBarDisplaySource;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.gauge.GaugeBlockEntity;
import org.patryk3211.powergrid.utility.Lang;

public class ElectricGaugeDisplaySource
extends PercentOrProgressBarDisplaySource {
    @Nullable
    protected Float getProgress(DisplayLinkContext context) {
        class_2586 class_25862 = context.getSourceBlockEntity();
        if (class_25862 instanceof GaugeBlockEntity) {
            GaugeBlockEntity gauge = (GaugeBlockEntity)class_25862;
            return Float.valueOf(gauge.getProgress());
        }
        return Float.valueOf(0.0f);
    }

    protected class_5250 formatNumeric(DisplayLinkContext context, Float currentLevel) {
        class_2586 class_25862 = context.getSourceBlockEntity();
        if (class_25862 instanceof GaugeBlockEntity) {
            GaugeBlockEntity gauge = (GaugeBlockEntity)class_25862;
            float value = gauge.getValue();
            if (this.getMode(context) == 1) {
                value = Math.abs(value);
            }
            return Lang.numberConstant(value).add(class_2561.method_43470((String)" ")).add(gauge.getUnit().get()).component();
        }
        return super.formatNumeric(context, currentLevel);
    }

    private int getMode(DisplayLinkContext context) {
        return context.sourceConfig().method_10550("Mode");
    }

    protected boolean progressBarActive(DisplayLinkContext context) {
        return this.getMode(context) == 0;
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }

    protected String getTranslationKey() {
        return "electric_gauge";
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 120, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.electric_gauge", "progress_bar", "absolute", "polarized")).titled(Lang.translateDirect("display_source.display_information", new Object[0])), "Mode");
    }
}

