/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.gauge;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.gauge.GaugeBlockEntity;
import org.patryk3211.powergrid.electricity.gauge.GaugeValueBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricWire;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.Unit;

public class PowerGaugeBlockEntity
extends GaugeBlockEntity {
    private static final float[] MAX_VALUES = new float[]{20.0f, 200.0f, 2000.0f, 20000.0f};
    private ElectricWire series;
    private ElectricWire shunt;

    public PowerGaugeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.gaugeValue = new GaugeValueBehaviour((class_2561)class_2561.method_43471((String)"powergrid.devices.gauge.power"), (class_2561)Unit.POWER.get().component(), MAX_VALUES, this, (ValueBoxTransform)new GaugeBlockEntity.BoxTransform());
        this.gaugeValue.withCallback(i -> {
            this.maxValue = MAX_VALUES[i];
            this.sendData();
        });
        behaviours.add((BlockEntityBehaviour)this.gaugeValue);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.maxValue = MAX_VALUES[this.gaugeValue.getValue()];
    }

    @Override
    public void tick() {
        float current = Math.abs(this.getValue());
        this.dialTarget = current > this.maxValue ? 1.125f : current / this.maxValue;
        this.applyPower(this.series);
        super.tick();
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        float resistance = this.resistance();
        builder.setTerminalCount(3);
        this.series = builder.connect(resistance, builder.terminalNode(0), builder.terminalNode(1));
        this.shunt = builder.connect(20000.0f, builder.terminalNode(0), builder.terminalNode(2));
    }

    @Override
    public float getValue() {
        return this.series.current() * this.shunt.potentialDifference();
    }

    @Override
    public Unit getUnit() {
        return Unit.POWER;
    }

    public static class_124 measurementColor(float value, float maxValue) {
        if ((double)value < (double)maxValue * 0.01) {
            return class_124.field_1063;
        }
        if ((double)value < (double)maxValue * 0.5) {
            return class_124.field_1062;
        }
        if ((double)value < (double)maxValue * 0.75) {
            return class_124.field_1065;
        }
        return class_124.field_1061;
    }

    public static void addTooltip(List<class_2561> tooltip, float power, float maxValue) {
        Lang.builder().translate("gui.power_meter.title", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        power = (float)Math.round(power * 100.0f) / 100.0f;
        String powerText = String.format("%.2f", Float.valueOf(power));
        if (Math.abs(power) > maxValue) {
            powerText = power > 0.0f ? String.format("> %.2f", Float.valueOf(maxValue)) : String.format("< %.2f", Float.valueOf(-maxValue));
        }
        Lang.builder().text(powerText).add(class_2561.method_43470((String)" ")).add(Unit.POWER.get()).style(PowerGaugeBlockEntity.measurementColor(Math.abs(power), maxValue)).forGoggles(tooltip, 1);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        PowerGaugeBlockEntity.addTooltip(tooltip, this.getValue(), this.maxValue);
        return true;
    }
}

