/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.light.bulb;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.patryk3211.powergrid.electricity.info.IHaveElectricProperties;
import org.patryk3211.powergrid.electricity.info.Power;
import org.patryk3211.powergrid.electricity.info.Resistance;
import org.patryk3211.powergrid.electricity.info.Voltage;
import org.patryk3211.powergrid.electricity.light.bulb.ILightBulb;
import org.patryk3211.powergrid.electricity.light.bulb.LightBulbState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlockEntity;

public class LightBulb
extends class_1792
implements ILightBulb,
IHaveElectricProperties {
    protected Supplier<Function<State, PartialModel>> modelSupplier = null;
    protected float T_max = 1200.0f;
    protected float R_max = 100.0f;
    protected float R_min = 15.0f;
    protected ILightBulb.Properties thermalProperties;
    protected float power = 0.0f;
    protected float voltage = 0.0f;

    public LightBulb(class_1792.class_1793 settings) {
        super(settings);
    }

    public static <I extends LightBulb, P> NonNullUnaryOperator<ItemBuilder<I, P>> setModelProvider(Supplier<Function<State, PartialModel>> provider) {
        return b -> {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> LightBulb.lambda$setModelProvider$2(b, (Supplier)provider));
            return b;
        };
    }

    public static <I extends LightBulb, P> NonNullUnaryOperator<ItemBuilder<I, P>> setProperties(float minResistance, float maxResistance, float operatingTemperature, float dissipationFactor, float overheatTemperature, float thermalMass) {
        return b -> {
            b.onRegister(item -> {
                item.T_max = operatingTemperature;
                item.R_max = maxResistance;
                item.R_min = minResistance;
                item.thermalProperties = new ILightBulb.Properties(dissipationFactor, thermalMass, overheatTemperature);
            });
            return b;
        };
    }

    public static <I extends LightBulb, P> NonNullUnaryOperator<ItemBuilder<I, P>> setProperties(float ratedPower, float ratedVoltage, float minResistance, float thermalMass) {
        float R_max = ratedVoltage * ratedVoltage / ratedPower;
        float operatingTemperature = 1450.0f;
        float dissipationFactor = ratedPower / 1428.0f;
        NonNullUnaryOperator<ItemBuilder<I, P>> result = LightBulb.setProperties(minResistance, R_max, 1450.0f, dissipationFactor, 1850.0f, thermalMass);
        return result.andThen(b -> {
            b.onRegister(item -> {
                item.power = ratedPower;
                item.voltage = ratedVoltage;
            });
            return b;
        });
    }

    @Override
    public float resistanceFunction(float temperature) {
        return LightBulb.resistanceFunction(this.R_min, this.R_max, this.T_max, temperature);
    }

    public static float resistanceFunction(float R_min, float R_max, float T_max, float temperature) {
        return R_min + (R_max - R_min) / T_max * temperature;
    }

    @Override
    public ILightBulb.Properties thermalProperties() {
        return this.thermalProperties;
    }

    @Override
    public LightBulbState createState(LightFixtureBlockEntity fixture) {
        return new SimpleState(this, fixture, this.modelSupplier);
    }

    @Override
    public void appendProperties(class_1799 stack, class_1657 player, List<class_2561> tooltip) {
        if (this.voltage > 0.0f && this.power > 0.0f) {
            Voltage.rated(this.voltage, player, tooltip);
            Power.rated(this.power, player, tooltip);
        } else {
            Resistance.series(this.R_max, player, tooltip);
        }
    }

    private static /* synthetic */ Runnable lambda$setModelProvider$2(ItemBuilder b, Supplier provider) {
        return () -> LightBulb.lambda$setModelProvider$1(b, (Supplier)provider);
    }

    private static /* synthetic */ void lambda$setModelProvider$1(ItemBuilder b, Supplier provider) {
        b.onRegister(arg_0 -> LightBulb.lambda$setModelProvider$0((Supplier)provider, arg_0));
    }

    private static /* synthetic */ void lambda$setModelProvider$0(Supplier provider, LightBulb item) {
        item.modelSupplier = provider;
    }

    public static class SimpleState
    extends LightBulbState {
        @Environment(value=EnvType.CLIENT)
        public Function<State, PartialModel> modelProvider;

        public <T extends class_1792> SimpleState(T bulb, LightFixtureBlockEntity fixture, Supplier<Function<State, PartialModel>> modelProviderSupplier) {
            super(bulb, fixture);
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> this.lambda$new$0((Supplier)modelProviderSupplier));
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public PartialModel getModel() {
            State state = State.OFF;
            if (this.burned) {
                state = State.BROKEN;
            } else {
                class_2680 blockState = this.fixture.method_11010();
                Integer powerLevel = (Integer)blockState.method_11654((class_2769)LightFixtureBlock.POWER);
                if (powerLevel == 1) {
                    state = State.LOW_POWER;
                } else if (powerLevel == 2) {
                    state = State.ON;
                }
            }
            return this.modelProvider.apply(state);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        @NotNull
        public PartialModel getLightModel() {
            return this.modelProvider.apply(State.LIGHT);
        }

        @Override
        public float getAlpha() {
            class_2680 blockState = this.fixture.method_11010();
            Integer powerLevel = (Integer)blockState.method_11654((class_2769)LightFixtureBlock.POWER);
            if (powerLevel == 2) {
                return 1.0f;
            }
            if (powerLevel == 1) {
                return Math.max(0.5625f, super.getAlpha());
            }
            return super.getAlpha();
        }

        private /* synthetic */ void lambda$new$0(Supplier modelProviderSupplier) {
            this.modelProvider = (Function)modelProviderSupplier.get();
        }
    }

    public static enum State {
        OFF,
        LOW_POWER,
        ON,
        BROKEN,
        LIGHT;

    }
}

